#pragma once
#include "global.h"
//ǰ
struct MyFPS;
struct MyView;
struct InputSetting_Keyboard;
struct InputSetting_Joystick;
struct GameFunc;
struct PlayerUIData;
class MyGame;
class Entity;
class EntityRes;
class GameMap;
class GameScript;
class GameUI;
class OrganyaPlayer;
class DmgNum;
class ScriptCmd;
class SlotDrawer;
class GameFlash;
struct MapLayer;
void MyCreateSDLWindow(SDL_Window** outSDL_Window, HWND* outHwnd);
void SystemTask();
MyTextureAndSRV* GetPxaTexture(const wchar_t* pxaName);
MyTextureAndSRV* GetPxaTextureInterArea(const wchar_t* pxaName, float scaleW, float scaleH);
MyTextureAndSRV* GetPidTexture(const wchar_t* pidName);
MyTextureAndSRV* GetPidTextureInterArea(const wchar_t* pidName, float scaleW, float scaleH);
MyTextureAndSRV* GetMsgboxTexture(const wchar_t* msgboxName);
MyTextureAndSRV* GetFaceTexture(const wchar_t* faceName);
MyTextureAndSRV* GetFaceTextureInterArea(const wchar_t* faceName, float scaleW, float scaleH);
MyTextureAndSRV* GetSysTexture(const wchar_t* sysName);
MyTextureAndSRV* GetMcuiTexture(const wchar_t* mcuiName);
MyTextureAndSRV* GetResTexture(UINT resID);
Mix_Chunk* GetSoundByName(const wchar_t* soundName);//ȡҪ
void* GetDrumByIndex(int drumIndex);//ȡ
void InitGameFunc(GameFunc* gameFunc);
void SwitchEnglishInput();
void ClearTexture(std::unordered_map<std::wstring, MyTextureAndSRV>* textureRes);
/*-----------------------------GameFunc----------------------------------------*/
void PlaySound(const wchar_t* soundName);//wav
int PlayLoopSound(const wchar_t* soundName);//ѭ
void StopLoopSound(int channelID);//ֹͣѭ
bool GetFullScreen();//Ƿȫ
void SetFullScreen(bool bFullScreen);//ʾȫ
bool GetShowDebug();//ǷʾϢ
void SetShowDebug(bool bShowDebug);//ʾϢ
void EnlargeWindow();//Ŵ󴰿
void ReduceWindow();//С
int GetMusicVolume();//ȡ[0-10]
void SetMusicVolume(int vol);//
int GetSoundVolume();//ȡЧ[0-10]
void SetSoundVolume(int vol);//Ч
void OpenGameController();//´ӵֱ豸
void GetScanCodeName(std::vector<wchar_t>* outName, SDL_Scancode key);//ȡɨ
void GetGameControllerKeyName(std::vector<wchar_t>* outName, SDL_GameControllerButtonBind* keyBind);//ȡֱ
void GetGameControllerName(std::vector<wchar_t>* outName, SDL_GameController* pGameController);//ȡֱ豸
void ResetKeyboard();//ü״̬
bool GetAnyKeyPress(SDL_Scancode* outKey);//ȡⰴ
bool GetAnyGameControllerKeyPress(SDL_GameController* pGameController, SDL_GameControllerButtonBind* keyBind);//ȡֱⰴ
bool GetKey(SDL_Scancode key);//ȡɨǷ
void ResetKeySetting_Player1Keyboard();//1м̰
void ResetKeySetting_Player1Joystick();//1ֱ
void ResetKeySetting_Player2Keyboard();//2м̰
void ResetKeySetting_Player2Joystick();//2ֱ
InputSetting_Keyboard* GetInputSetting_Player1Keyboard();//ȡ1
InputSetting_Joystick* GetInputSetting_Player1Joystick();//ȡ1ֱ
InputSetting_Keyboard* GetInputSetting_Player2Keyboard();//ȡ2
InputSetting_Joystick* GetInputSetting_Player2Joystick();//ȡ2ֱ
SDL_GameController* GetGameControllerFromIndex(int index);//±ȡֱ豸
int GetPlayer1ControllerType();//ȡ1
int GetPlayer2ControllerType();//ȡ2
void SetPlayer1ControllerType(int type);//1
void SetPlayer2ControllerType(int type);//2
void LoadConfig();//Ϸѡ
void SaveConfig();//Ϸѡ
std::weak_ptr<Entity> GetMyChar_Player1(EntityRes* entityRes);//ȡ1ʵ
std::weak_ptr<Entity> GetMyChar_Player1_menuKeyboard(EntityRes* entityRes);//ȡ1Ĳ˵ʵ
std::weak_ptr<Entity> GetMyChar_Player2(EntityRes* entityRes);//ȡ2ʵ
std::weak_ptr<Entity> GetMyChar_Player2_menuKeyboard(EntityRes* entityRes);//ȡ2Ĳ˵ʵ
MapLayer* GetMapLayer(GameMap* gameMap, const wchar_t* layerName);//ȡͼͼ
void GetMapSize(GameMap* gameMap, int* outMapW, int* outMapH);//ȡߴ
void SetNewNameOption(const wchar_t* gameName, int playerNum, int difficulty);//Ϸ
void SetSaveName(const wchar_t* saveName);//õǰ浵ļ
void DelSave(const wchar_t* saveName);//ɾ浵
void SaveNameGetRoomName(std::wstring* outRoomName, const wchar_t* saveName);//浵ȡ
int SaveNameGetGameDifficulty(const wchar_t* saveName);//浵ȡϷѶ
void WriteData(const wchar_t* eid, const wchar_t* field, const wchar_t* value);//д
const wchar_t* ReadData(const wchar_t* eid, const wchar_t* field, const wchar_t* defaultVal);//ȡ
void SetPauseMenuBackGame(bool bBack);//ͣ˵Ϸ
void SetPauseMenuBackTitle(bool bBack);//ͣ˵ر⻭
void SetDmgNum(DmgNum* dmgNum, int val, float x, float y, int style, std::weak_ptr<Entity> e);//һ˺ֵʾ
void SetEntity(std::shared_ptr<Entity> parent, std::shared_ptr<Entity> newE);//һʵ
void StartEvent(GameScript* gameScript, const wchar_t* eventName, const wchar_t* triggerType);//¼
bool IsLockKeyboard(GameScript* gameScript);//Ƿ
bool ScriptIsRunning(GameScript* gameScript);//Ƿ¼
PlayerUIData* GetPlayerUIData(GameUI* gameUI, int playerIndex);//ȡUIʾ
void StopMusic();//ֹͣ
void ScreenShot();//ȡͼ
void QuitGame();//˳Ϸ
const wchar_t* GetLanguage();//ȡϷ
void SetLanguage(const wchar_t* lang);//
void GetAllLanguage(std::vector<std::wstring>* languageList);//ȡе
void ReloadLanguage();//Ч
void SetLastPlaySlot(int slotPage, int index);//Ĵ浵λ
void GetLastPlaySlot(int* outSlotPage, int* outIndex);//ȡĴ浵λ
void SetMyChar_Player1(MyGame* game, std::weak_ptr<Entity> e);//1Ŀʵ
void SetMyChar_Player2(MyGame* game, std::weak_ptr<Entity> e);//2Ŀʵ
void SetGlobalEntity(MyGame* game, std::shared_ptr<Entity> e, const wchar_t* globalEntityID);//ʵõȫ
std::weak_ptr<Entity> GetGlobalEntity(MyGame* game, const wchar_t* globalEntityID);//ȡȫʵָ
std::unordered_map<std::wstring, std::weak_ptr<Entity>>* GetGlobalEntityTable(MyGame* game);//ȡȫʵָ
int GetPlayerIndex(MyGame* game, std::weak_ptr<Entity> e);//ȡǰʵ±
std::weak_ptr<Entity> GetPlayerDistance(MyGame* game, float x, float y);//ȡõ
std::weak_ptr<Entity>GetPlayerDistanceLR(MyGame* game, float x, float y, int lr);//ȡõһ
std::weak_ptr<Entity>GetPlayerDistanceWithLineTest(MyGame* game, float x, float y);//ȡõĿֱ
std::weak_ptr<Entity>GetPlayerDistanceLRWithLineTest(MyGame* game, float x, float y, int lr);//ȡõһĿֱ
void SetQuake(MyGame* game, int times, int mode);//mode:0С1󶶶
void SetLocalCamera(MyGame* game, std::weak_ptr<Entity> e, float focusTimes);//۽λ
void UnsetLocalCamera(MyGame* game, std::weak_ptr<Entity> e);//ȡõλľ۽
bool InBossFight(MyGame* game);//ǷBossս
std::weak_ptr<Entity> GetCheckEventPlayer(MyGame* game);//ȡһڵ¼
int PlayerHaveItem(MyGame* game, const wchar_t* regID);//ӵĳƷ
int PlayerAddItem(MyGame* game, const wchar_t* regID, int num);//ƷظƷ
int PlayerDeleteItem(MyGame* game, const wchar_t* regID, int num);//ƳƷ-1ΪƳȫ,ʣ
void DecodeRecord(const wchar_t* recordStr, const void** outInputArr, size_t* outDataSize);//¼
void SlotPageEnableDraw(SlotDrawer* slotDrawer, bool bEnable);//ô浵ҳ
void SlotPageDrawClear(SlotDrawer* slotDrawer);//浵ҳб
void SlotPageAddDraw(SlotDrawer* slotDrawer, const wchar_t* saveName, std::weak_ptr<Entity> player1Icon, std::weak_ptr<Entity> player2Icon);//ҪƵҴ浵Ϣб
void SlotPageReset(SlotDrawer* slotDrawer);//ô浵ҳ
void SetScreenFlash(GameFlash* gameFlash, int times);//Ļ˸
/*-----------------------------------ϵͳ----------------------------------*/
void SysKeyBoard();//̹̺
void ResetScale();//scale
void ClearDbgFont();
void ClearLoadedTexture();
void ClearLoadedSound();
void DrawDebug(MyGame* pGame);
void MapTest(const wchar_t* mapName, const wchar_t* mycharName, int xPos, int yPos);
void Record(const wchar_t* mapName, const wchar_t* mycharName, int xPos, int yPos, int endPosX, int endPosY);
void IntroStage();
bool TitleStage();
bool GameStage();
bool PauseMenu(float delteTime_MainGame);
void Quit();
void LoadEntityDll();
std::shared_ptr<Entity> GameCreateEntity(const wchar_t* name);
void SplitString(std::vector<std::wstring>* outList, const wchar_t* splitStr, wchar_t delimiter);//ַ
void SaveGameToFile();//Ϸ
bool LoadGameFromFile();//ȡϷ
void GameRestart();//Ϸ
void GameBackTitle();//ر⻭
void LoadSoundTable();
void LoadFontTable();
void LoadFaceTable();
void PlaySoundProc();
void EntityInitCheck(std::shared_ptr<Entity>& we);
void EntitySharedPtrCheck(std::shared_ptr<Entity>& we);
void FreezeGame();
void ActivateGame();
LRESULT CALLBACK SubclassedWndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
extern bool bShowDebug;
extern HWND hwnd;
extern TTF_Font* dbgFont;
extern std::vector<std::wstring> cmdList;
extern std::unordered_map<std::wstring, std::unordered_map<std::wstring, std::wstring>> entitySaveVar;//ʵݴ浵
extern InputSetting_Keyboard inputSetting_player1Keyboard;
extern InputSetting_Joystick inputSetting_player1Joystick;
extern InputSetting_Keyboard inputSetting_player2Keyboard;
extern InputSetting_Joystick inputSetting_player2Joystick;
extern int player1ControllerType;//0̡1ֱ
extern int player2ControllerType;//0̡1ֱ
extern std::wstring language_now;//ǰ
extern std::map<std::wstring, std::wstring> roomNameTable;//õķ
extern std::unordered_map<std::wstring, std::wstring> soundTable;//Ч
extern std::unordered_map<int, std::wstring> drumTable;//ı
extern std::string pixelFont_size12;
extern int pixelFont_size12_arg;
extern std::string pixelFont_size14;
extern int pixelFont_size14_arg;
extern std::string highQualityFont;
extern float msgboxTextOffy;
extern std::wstring gameOption_gameName;
extern int gameOption_playerNum;
extern int gameOption_difficulty;
extern MusicPlayer pMusic;
extern OrganyaPlayer orgPlayer;
extern bool gameSpeedX3;//3Ϸٶ
extern bool bLockCamera;//סͷ
extern ScriptCmd* mainGameCmd;//Ϸűָ
extern bool bDisableSound;//ֻ֡ʱ
//ױ
struct FaceDisplayInfo
{
	std::wstring facefile;//ڵļ
	MyRect src;
};
extern std::unordered_map<std::wstring, bool> facefileTable;
extern std::unordered_map<std::wstring, FaceDisplayInfo> faceIDTable;