#include "ScriptLuaFunc.h"
#include "ScriptCmd.h"
#include "main.h"

ScriptCmd* GetCmd(lua_State* L)
{
	void** p = (void**)lua_getextraspace(L);
	ScriptCmd* cmd = (ScriptCmd*)(*p);
	if (cmd->IsMainGame())
		return mainGameCmd;
	else
		return cmd;
}

ScriptCmd* GetCmdSub(lua_State* L)
{
	void** p = (void**)lua_getextraspace(L);
	ScriptCmd* cmd = (ScriptCmd*)(*p);
	return cmd;
}

#define LUAGETCMD auto cmd = GetCmd(L)
#define LUAGETCMD_SUB auto cmd = GetCmdSub(L)

const luaL_Reg tscFuncList[] =
{
	{"TRA", Tsc_TRA},
	{"DBG", Tsc_DBG},
	{"WAI", Tsc_WAI},
	{"WAS", Tsc_WAS},
	{"STY", Tsc_STY},
	{"MSG", Tsc_MSG},
	{"MS2", Tsc_MS2},
	{"MS3", Tsc_MS3},
	{"MS4", Tsc_MS4},
	{"MSS", Tsc_MSS},
	{"TUR", Tsc_TUR},
	{"NOD", Tsc_NOD},
	{"CAT", Tsc_CAT},
	{"CLR", Tsc_CLR},
	{"CLO", Tsc_CLO},
	{"FCL", Tsc_FCL},
	{"FNT", Tsc_FNT},
	{"FSZ", Tsc_FSZ},
	{"FAC", Tsc_FAC},
	{"CMU", Tsc_CMU},
	{"PMU", Tsc_PMU},
	{"RMU", Tsc_RMU},
	{"SOU", Tsc_SOU},
	{"CMU2", Tsc_CMU2},
	{"PMU2", Tsc_PMU2},
	{"RMU2", Tsc_RMU2},
	{"PRI", Tsc_PRI},
	{"KEY", Tsc_KEY},
	{"MM0", Tsc_MM0},
	{"MV0", Tsc_MV0},
	{"MOV", Tsc_MOV},
	{"SLR", Tsc_SLR},
	{"GLR", Tsc_GLR},
	{"MYB", Tsc_MYB},
	{"FON", Tsc_FON},
	{"FOM", Tsc_FOM},
	{"MNA", Tsc_MNA},
	{"FAI", Tsc_FAI},
	{"FAO", Tsc_FAO},
	{"HMC", Tsc_HMC},
	{"SMC", Tsc_SMC},
	{"ANP", Tsc_ANP},
	{"AMC", Tsc_AMC},
	{"ATP", Tsc_ATP},
	{"TMC", Tsc_TMC},
	{"TNP", Tsc_TNP},
	{"CNP", Tsc_CNP},
	{"MNP", Tsc_MNP},
	{"BSL", Tsc_BSL},
	{"SAV", Tsc_SAV},
	{"LAY", Tsc_LAY},
	{"FLP", Tsc_FLP},
	{"FLS", Tsc_FLS},
	{"FLJ", Tsc_FLJ},
	{"YNJ", Tsc_YNJ},
	{"YES", Tsc_YES},
	{"INI", Tsc_INI},
	{"ESC", Tsc_ESC},
	{"W99", Tsc_W99},
	{"MAP", Tsc_MAP},
	{"PLY", Tsc_PLY},
	{"SNP", Tsc_SNP},
	{"DNP", Tsc_DNP},
	{"MLP", Tsc_MLP},
	{"ECJ", Tsc_ECJ},
	{"LIP", Tsc_LIP},
	{"MIP", Tsc_MIP},
	{"TGR", Tsc_TGR},
	{"ELT", Tsc_ELT},
	{"SPL", Tsc_SPL},
	{"SGP", Tsc_SGP},
	{"CGP", Tsc_CGP},
	{"DGP", Tsc_DGP},
	{"AGP", Tsc_AGP},
	{"P2A", Tsc_P2A},
	{"WET", Tsc_WET},
	{"EID", Tsc_EID},
	{"RGI", Tsc_RGI},
	{"ITP", Tsc_ITP},
	{"ITS", Tsc_ITS},
	{"ITJ", Tsc_ITJ},
	{"ITC", Tsc_ITC},
	{"RGM", Tsc_RGM},
	{"MSA", Tsc_MSA},
	{"MSD", Tsc_MSD},
	{"MSR", Tsc_MSR},
	{"MSJ", Tsc_MSJ},
	{"SUB", Tsc_SUB},
	{"LOC", Tsc_LOC},
	{"GIT", Tsc_GIT},
	{"DBG", Tsc_DBG},
	{"IMM", Tsc_IMM},
	{"SKP", Tsc_SKP},
	{"SKS", Tsc_SKS},
	{"SKJ", Tsc_SKJ},
	{"POS", Tsc_POS},
	{"CMP", Tsc_CMP},
	{"QUA", Tsc_QUA},
	{"SWC", Tsc_SWC},
	{"SWP", Tsc_SWP},
	{"MCN", Tsc_MCN},
	{"MCI", Tsc_MCI},
	{"GOP", Tsc_GOP},
	{"FLA", Tsc_FLA},
	{"KIL", Tsc_KIL},
	{"STA", Tsc_STA},
	{"ZAM", Tsc_ZAM},
	{"RST", Tsc_RST},
	{"CRE", Tsc_CRE},
	{"KEN", Tsc_KEN},
	{"DIF", Tsc_DIF},
	{"TIM", Tsc_TIM},
	{"STC", Tsc_STC},
	{"LTC", Tsc_LTC},
	{NULL, NULL},
};

int LuaOpenTsc(lua_State* L)
{
	luaL_newlib(L, tscFuncList);
	return 1;
}

lua_State* NewScriptL(void* pScriptCmd)
{
	auto L = luaL_newstate();
	luaL_openlibs(L);
	luaL_requiref(L, "tsc", LuaOpenTsc, 0);
	std::string cmd;
	char appendStr[MAX_PATH];
	sprintf_s(appendStr, "tsc = require(\"tsc\");\n");
	cmd.append(appendStr);
	for (auto& f : tscFuncList)
		if (f.name != NULL)
		{
			sprintf_s(appendStr, "%s = tsc.%s;\n", f.name, f.name);
			cmd.append(appendStr);
		}
	luaL_dostring(L, cmd.c_str());

	//Cmd
	void** p = (void**)lua_getextraspace(L);
	*p = pScriptCmd;
	return L;
}

int Tsc_TRA(lua_State* L)
{
	LUAGETCMD;
	auto argNum = lua_gettop(L);
	if (!(argNum == 4 || argNum == 6))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"TRA(mapName,eventName,x,y)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űTRA", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 4)
		cmd->TRA(lua_tostring(L, 1), lua_tostring(L, 2), (int)lua_tointeger(L, 3), (int)lua_tointeger(L, 4));
	else if (argNum == 6)
		cmd->TRA(lua_tostring(L, 1), lua_tostring(L, 2), (int)lua_tointeger(L, 3), (int)lua_tointeger(L, 4), (int)lua_tointeger(L, 5), (int)lua_tointeger(L, 6));
	return 0;
}

int Tsc_DBG(lua_State* L)
{
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"DBG(message)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űDBG", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (lua_isnumber(L, 1))
	{
		wchar_t wbuff[MAX_PATH];
		float val = (float)lua_tonumber(L, 1);
		swprintf_s(wbuff, L"%f", val);
		if (MessageBoxW(hwnd, wbuff, L"", MB_OKCANCEL) == IDCANCEL)
			exit(0);
	}
	else
	{
		std::vector<wchar_t> wbuff;
		UTF8ToUTF16(lua_tostring(L, 1), &wbuff);
		if (MessageBoxW(hwnd, wbuff.data(), L"", MB_OKCANCEL) == IDCANCEL)
			exit(0);
	}
	return 0;
}

int Tsc_WAI(lua_State* L)
{
	LUAGETCMD;
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"WAI(times)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űWAI", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	cmd->WAI((int)lua_tointeger(L, 1));
	return lua_yield(L, 0);
}

int Tsc_WAS(lua_State* L)
{
	LUAGETCMD;
	cmd->WAS();
	return lua_yield(L, 0);
}

int Tsc_STY(lua_State* L)
{
	LUAGETCMD;
	auto argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"STY(style)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSTY", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->STY(lua_tostring(L, 1));
	else
		cmd->STY("");
	return 0;
}

int Tsc_MSG(lua_State* L)
{
	LUAGETCMD;
	auto argNum = lua_gettop(L);
	if (!(argNum == 1 || argNum == 2))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"MSG(text,mode=0)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űMSG", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->MSG(lua_tostring(L, 1), 0);
	else if (argNum == 2)
		cmd->MSG(lua_tostring(L, 1), (int)lua_tointeger(L, 2));
	return lua_yield(L, 0);
}

int Tsc_MS2(lua_State* L)
{
	LUAGETCMD;
	auto argNum = lua_gettop(L);
	if (!(argNum == 1 || argNum == 2))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"MS2(text,mode=0)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űMS2", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->MS2(lua_tostring(L, 1), 0);
	else if (argNum == 2)
		cmd->MS2(lua_tostring(L, 1), (int)lua_tointeger(L, 2));
	return lua_yield(L, 0);
}

int Tsc_MS3(lua_State* L)
{
	LUAGETCMD;
	auto argNum = lua_gettop(L);
	if (!(argNum == 1 || argNum == 2))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"MS3(text,mode=0)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űMS3", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->MS3(lua_tostring(L, 1), 0);
	else if (argNum == 2)
		cmd->MS3(lua_tostring(L, 1), (int)lua_tointeger(L, 2));
	return lua_yield(L, 0);
}

int Tsc_MS4(lua_State* L)
{
	LUAGETCMD;
	auto argNum = lua_gettop(L);
	if (!(argNum == 1 || argNum == 2))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"MS4(text,mode=0)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űMS4", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->MS4(lua_tostring(L, 1), 0);
	else if (argNum == 2)
		cmd->MS4(lua_tostring(L, 1), (int)lua_tointeger(L, 2));
	return lua_yield(L, 0);
}

int Tsc_MSS(lua_State* L)
{
	LUAGETCMD;
	auto argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"MSS(num=5)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űMSS", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->MSS((int)lua_tointeger(L, 1));
	else
		cmd->MSS(5);
	return 0;
}

int Tsc_TUR(lua_State* L)
{
	LUAGETCMD;
	auto argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"TUR(true)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űTUR", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->TUR(lua_toboolean(L, 1));
	else
		cmd->TUR(true);
	return 0;
}

int Tsc_NOD(lua_State* L)
{
	LUAGETCMD;
	cmd->NOD();
	return lua_yield(L, 0);
}

int Tsc_CAT(lua_State* L)
{
	LUAGETCMD;
	auto argNum = lua_gettop(L);
	if (!(argNum == 1 || argNum == 2))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"CAT(text,mode=0)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űCAT", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->CAT(lua_tostring(L, 1), 0);
	else if (argNum == 2)
		cmd->CAT(lua_tostring(L, 1), (int)lua_tointeger(L, 2));
	return lua_yield(L, 0);
}

int Tsc_CLR(lua_State* L)
{
	LUAGETCMD;
	cmd->CLR();
	return 0;
}

int Tsc_CLO(lua_State* L)
{
	LUAGETCMD;
	cmd->CLO();
	return 0;
}

int Tsc_FCL(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	int argNum = lua_gettop(L);
	if (argNum > 4)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"FCL(colorID)\nFCL(colorID,a)\nFCL(r,g,b)\nFCL(r,g,b,a)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űFCL", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	BYTE r = 0xff, g = 0xff, b = 0xff, a = 0xff;
	switch (argNum)
	{
	default:
	case 0:
		break;
	case 2:
		a = (int)lua_tointeger(L, 2);
	case 1://ʺɫ
		switch ((int)lua_tointeger(L, 1))
		{
		case 0://
			r = 217;
			g = 82;
			b = 73;
			break;
		case 1://
			r = 217;
			g = 146;
			b = 73;
			break;
		case 2://
			r = 255;
			g = 246;
			b = 90;
			break;
		case 3://
			r = 57;
			g = 192;
			b = 32;
			break;
		case 4://
			r = 54;
			g = 211;
			b = 217;
			break;
		case 5://
			r = 54;
			g = 85;
			b = 214;
			break;
		case 6://
			r = 164;
			g = 127;
			b = 168;
			break;
		case 7://
			r = 255;
			g = 255;
			b = 255;
			break;
		case 8://
			r = 150;
			g = 150;
			b = 150;
			break;
		case 9://
			r = 0;
			g = 0;
			b = 0;
			break;
		}
		break;
	case 3:
		r = (int)lua_tointeger(L, 1);
		g = (int)lua_tointeger(L, 2);
		b = (int)lua_tointeger(L, 3);
		break;
	case 4:
		r = (int)lua_tointeger(L, 1);
		g = (int)lua_tointeger(L, 2);
		b = (int)lua_tointeger(L, 3);
		a = (int)lua_tointeger(L, 4);
		break;
	}
	cmd->FCL(r, g, b, a);
	return 0;
}

int Tsc_FNT(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	int argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"FNT(fontName)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űFNT", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 0)
		cmd->FNT("");
	else
		cmd->FNT(lua_tostring(L, 1));
	return 0;
}

int Tsc_FSZ(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	int argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"FSZ(fontSize=default)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űFSZ", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 0)
		cmd->FSZ();
	else
		cmd->FSZ((int)lua_tointeger(L, 1));
	return 0;
}

int Tsc_FAC(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	int argNum = lua_gettop(L);
	if (!(argNum == 0 || argNum == 1))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"FAC(faceID)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űFAC", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 0)
		cmd->FAC();
	else
		cmd->FAC(lua_tostring(L, 1));
	return 0;
}

int Tsc_CMU(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	int argNum = lua_gettop(L);
	if (argNum > 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"CMU(musicName,fadeInSecond=0)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űCMU", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->CMU(lua_tostring(L, 1), 0);
	else if (argNum == 2)
		cmd->CMU(lua_tostring(L, 1), (float)lua_tonumber(L, 2));
	return 0;
}

int Tsc_PMU(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	int argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"PMU(fadeOutSecond=0)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űPMU", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->PMU((float)lua_tonumber(L, 1));
	else
		cmd->PMU(0);
	return 0;
}

int Tsc_RMU(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	int argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"RMU(fadeInSecond=0)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űRMU", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->RMU((float)lua_tonumber(L, 1));
	else
		cmd->RMU(0);
	return 0;
}

int Tsc_SOU(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	int argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"SOU2(soundName)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSOU", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	cmd->SOU(lua_tostring(L, 1));
	return 0;
}

int Tsc_CMU2(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	int argNum = lua_gettop(L);
	if (argNum > 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"CMU2(musicName,fadeInSecond=0)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űCMU", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->CMU2(lua_tostring(L, 1), 0);
	else if (argNum == 2)
		cmd->CMU2(lua_tostring(L, 1), (float)lua_tonumber(L, 2));
	return 0;
}

int Tsc_PMU2(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	int argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"PMU2(fadeOutSecond=0)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űPMU", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->PMU2((float)lua_tonumber(L, 1));
	else
		cmd->PMU2(0);
	return 0;
}

int Tsc_RMU2(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	int argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"RMU2(fadeInSecond=0)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űRMU", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->RMU2((float)lua_tonumber(L, 1));
	else
		cmd->RMU2(0);
	return 0;
}

int Tsc_PRI(lua_State* L)
{
	LUAGETCMD;
	cmd->PRI();
	return 0;
}

int Tsc_KEY(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"KEY(bKey = true)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űKEY", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->KEY(lua_toboolean(L, 1));
	else
		cmd->KEY();
	return 0;
}

int Tsc_MM0(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"MM0(playerIndex = all)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űMM0", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->MM0((int)lua_tointeger(L, 1));
	else
		cmd->MM0();
	return 0;
}

int Tsc_MV0(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"MV0(playerIndex = all)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űMV0", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->MV0((int)lua_tointeger(L, 1));
	else
		cmd->MV0();
	return 0;
}

int Tsc_MOV(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (!(argNum >= 1 && argNum <= 5))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"MOV(x,y,playerIndex = all)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űMOV", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (lua_isnumber(L, 1))
	{
		if (argNum == 1)
		{
			cmd->MOV((int)lua_tointeger(L, 1));
		}
		else if (argNum == 2)
		{
			cmd->MOV((int)lua_tointeger(L, 1),
				(int)lua_tointeger(L, 2));
		}
		else if (argNum == 3)
		{
			if (lua_isnumber(L, 3))
			{
				cmd->MOV((int)lua_tointeger(L, 1),
					(int)lua_tointeger(L, 2),
					(int)lua_tointeger(L, 3));
			}
			else
			{
				cmd->MOV((int)lua_tointeger(L, 1),
					(int)lua_tointeger(L, 2),
					lua_tostring(L, 3));
			}
		}
		else if (argNum == 4)
		{
			cmd->MOV((int)lua_tointeger(L, 1),
				(int)lua_tointeger(L, 2),
				(int)lua_tointeger(L, 3),
				(int)lua_tointeger(L, 4));
		}
		else if (argNum == 5)
		{
			if (lua_isnumber(L, 5))
			{
				cmd->MOV((int)lua_tointeger(L, 1),
					(int)lua_tointeger(L, 2),
					(int)lua_tointeger(L, 3),
					(int)lua_tointeger(L, 4),
					(int)lua_tointeger(L, 5));
			}
			else
			{
				cmd->MOV((int)lua_tointeger(L, 1),
					(int)lua_tointeger(L, 2),
					(int)lua_tointeger(L, 3),
					(int)lua_tointeger(L, 4),
					lua_tostring(L, 5));
			}
		}
	}
	else
	{
		if (argNum == 1)
		{
			cmd->MOV(lua_tostring(L, 1));
		}
		else if (argNum == 2)
		{
			cmd->MOV(lua_tostring(L, 1), (int)lua_tointeger(L, 2));
		}
	}
	return 0;
}

int Tsc_SLR(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1 && argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"SLR(lr,playerIndex = all)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSLR", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
	{
		if (lua_isnumber(L, 1))
			cmd->SLR((int)lua_tointeger(L, 1));
		else
			cmd->SLR(lua_tostring(L, 1));
	}
	else if(argNum == 2)
	{
		if (lua_isnumber(L, 1))
			cmd->SLR((int)lua_tointeger(L, 1), (int)lua_tointeger(L, 2));
		else
			cmd->SLR(lua_tostring(L, 1), (int)lua_tointeger(L, 2));
	}
	return 0;
}

int Tsc_GLR(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"GLR(playerIndex)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSLR", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	lua_pushinteger(L, cmd->GLR((int)lua_tointeger(L, 1)));
	return 1;
}

int Tsc_MYB(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1 && argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"MYB(lr,playerIndex = all)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űMYB", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
	{
		cmd->MYB((int)lua_tointeger(L, 1));
	}
	else if (argNum == 2)
	{
		cmd->MYB((int)lua_tointeger(L, 1),
			(int)lua_tointeger(L, 2));
	}
	return 0;
}

int Tsc_FON(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (!argNum || argNum > 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"FON(eventName,focusTimes=16)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űFON", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
	{
		cmd->FON(lua_tostring(L, 1), 16);
	}
	else if (argNum == 2)
	{
		cmd->FON(lua_tostring(L, 1), (float)lua_tonumber(L, 2));
	}
	return 0;
}

int Tsc_FOM(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum > 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"FOM(focusTimes=16,playerIndex = all)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űFOM", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 0)
		cmd->FOM(16);
	else if (argNum == 1)
		cmd->FOM((float)lua_tonumber(L, 1));
	else if (argNum == 2)
		cmd->FOM((float)lua_tonumber(L, 1), (int)lua_tointeger(L, 2));
	return 0;
}

int Tsc_MNA(lua_State* L)
{
	LUAGETCMD;
	cmd->MNA();
	return 0;
}

int Tsc_FAI(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"FAI(direction=5)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űFAI", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->FAI((int)lua_tointeger(L, 1));
	else
		cmd->FAI(5);
	return lua_yield(L, 0);
}

int Tsc_FAO(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"FAO(direction=5)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űFAO", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->FAO((int)lua_tointeger(L, 1));
	else
		cmd->FAO(5);
	return lua_yield(L, 0);
}

int Tsc_HMC(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"HMC(playerIndex = all)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űHMC", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 0)
		cmd->HMC();
	else if (argNum == 1)
	{
		if (lua_isnumber(L, 1))
			cmd->HMC((int)lua_tointeger(L, 1));
		else
			cmd->HMC(lua_tostring(L, 1));
	}
	return 0;
}

int Tsc_SMC(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"SMC(playerIndex = all)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSMC", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 0)
		cmd->SMC();
	else if (argNum == 1)
	{
		if (lua_isnumber(L, 1))
			cmd->SMC((int)lua_tointeger(L, 1));
		else
			cmd->SMC(lua_tostring(L, 1));
	}
	return 0;
}

int Tsc_ANP(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (!(argNum == 1 || argNum == 2 || argNum == 3))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"ANP(eventName,stateID,lr)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űANP", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
	{
		if (lua_isnumber(L, 1))
			cmd->ANP((int)lua_tointeger(L, 1));
		else
			cmd->ANP(lua_tostring(L, 1));
	}
	else
	{
		if (lua_isnumber(L, 2))
		{
			if (argNum == 2)
				cmd->ANP(lua_tostring(L, 1), (int)lua_tointeger(L, 2));
			else if (argNum == 3)
				cmd->ANP(lua_tostring(L, 1), (int)lua_tointeger(L, 2), (int)lua_tointeger(L, 3));
		}
		else
		{
			if (argNum == 2)
				cmd->ANP(lua_tostring(L, 1), lua_tostring(L, 2));
			else if (argNum == 3)
				cmd->ANP(lua_tostring(L, 1), lua_tostring(L, 2), (int)lua_tointeger(L, 3));
		}
	}
	return 0;
}

int Tsc_AMC(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (!(argNum == 1 || argNum == 2 || argNum == 3))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"AMC(stateID,lr,playerIndex = all)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űAMC", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (lua_isnumber(L, 1))
	{
		if (argNum == 1)
			cmd->AMC((int)lua_tointeger(L, 1));
		else if (argNum == 2)
		{
			if (lua_isnumber(L, 2))
				cmd->AMC((int)lua_tointeger(L, 1), (int)lua_tointeger(L, 2));
			else
				cmd->AMC((int)lua_tointeger(L, 1), lua_tostring(L, 2));
		}
		else if (argNum == 3)
		{
			if (lua_isnumber(L, 3))
				cmd->AMC((int)lua_tointeger(L, 1), (int)lua_tointeger(L, 2), (int)lua_tointeger(L, 3));
			else
				cmd->AMC((int)lua_tointeger(L, 1), (int)lua_tointeger(L, 2), lua_tostring(L, 3));
		}
	}
	else
	{
		if (argNum == 1)
			cmd->AMC(lua_tostring(L, 1));
		else if (argNum == 2)
		{
			if (lua_isnumber(L, 2))
				cmd->AMC(lua_tostring(L, 1), (int)lua_tointeger(L, 2));
			else
				cmd->AMC(lua_tostring(L, 1), lua_tostring(L, 2));
		}
		else if (argNum == 3)
		{
			if (lua_isnumber(L, 3))
				cmd->AMC(lua_tostring(L, 1), (int)lua_tointeger(L, 2), (int)lua_tointeger(L, 3));
			else
				cmd->AMC(lua_tostring(L, 1), (int)lua_tointeger(L, 2), lua_tostring(L, 3));
		}
	}
	return 0;
}

int Tsc_ATP(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"ATP(npcName,stateName)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űATP", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	cmd->ATP(lua_tostring(L, 1), lua_tostring(L, 2));
	return 0;
}

int Tsc_TMC(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1 && argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"TMC(enable,playerIndex = all)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űTMC", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->TMC(lua_toboolean(L, 1));
	else if(argNum == 2)
		cmd->TMC(lua_toboolean(L, 1), (int)lua_tointeger(L, 2));
	return 0;
}

int Tsc_TNP(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"TNP(eventName,enable)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űTNP", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	cmd->TNP(lua_tostring(L, 1), lua_toboolean(L, 2));
	return 0;
}

int Tsc_CNP(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (!(argNum == 2 || argNum == 3 || argNum == 4))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"CNP(eventName,npcName,stateID,lr)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űCNP", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 2)
		cmd->CNP(lua_tostring(L, 1), lua_tostring(L, 2));
	else if (argNum == 3)
		cmd->CNP(lua_tostring(L, 1), lua_tostring(L, 2), (int)lua_tointeger(L, 3));
	else if (argNum == 4)
		cmd->CNP(lua_tostring(L, 1), lua_tostring(L, 2), (int)lua_tointeger(L, 3), (int)lua_tointeger(L, 4));
	return 0;
}

int Tsc_MNP(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (!(argNum == 2 || argNum == 4))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"MNP(eventName,x,y,lr)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űMNP", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 2)
		cmd->MNP(lua_tostring(L, 1), lua_tostring(L, 2));
	else if (argNum == 4)
		cmd->MNP(lua_tostring(L, 1), (int)lua_tointeger(L, 2), (int)lua_tointeger(L, 3), (int)lua_tointeger(L, 4));
	return 0;
}

int Tsc_BSL(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (!(argNum == 1 || argNum == 2))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"BSL(eventName,LineSize=hp)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űBSL", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->BSL(lua_tostring(L, 1));
	else if (argNum == 2)
		cmd->BSL(lua_tostring(L, 1), (int)lua_tointeger(L, 2));
	return 0;
}

int Tsc_SAV(lua_State* L)
{
	LUAGETCMD;
	cmd->SAV();
	return 0;
}

int Tsc_LAY(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"LAY(layerName,bVisible)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űLAY", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	cmd->LAY(lua_tostring(L, 1), lua_toboolean(L, 2));
	return 0;
}

int Tsc_FLP(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"FLP(flagName)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űFLP", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	cmd->FLP(lua_tostring(L, 1));
	return 0;
}

int Tsc_FLS(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"FLS(flagName)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űFLS", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	cmd->FLS(lua_tostring(L, 1));
	return 0;
}

int Tsc_FLJ(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"FLJ(flagName)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űFLJ", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	bool bExist = cmd->FLJ(lua_tostring(L, 1));
	lua_pushboolean(L, bExist);
	return 1;
}

int Tsc_YNJ(lua_State* L)
{
	LUAGETCMD;
	cmd->YNJ();
	return lua_yield(L, 0);
}

int Tsc_YES(lua_State* L)
{
	LUAGETCMD;
	lua_pushboolean(L, cmd->YES());
	return 1;
}

int Tsc_INI(lua_State* L)
{
	LUAGETCMD;
	cmd->INI();
	return 0;
}

int Tsc_ESC(lua_State* L)
{
	LUAGETCMD;
	cmd->ESC();
	return 0;
}

int Tsc_W99(lua_State* L)
{
	LUAGETCMD;
	cmd->W99();
	return 0;
}

int Tsc_MAP(lua_State* L)
{
	mainGameCmd->MAP();
	return 0;
}

int Tsc_PLY(lua_State* L)
{
	LUAGETCMD;
	lua_pushinteger(L, cmd->PLY());
	return 1;
}

int Tsc_SNP(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (!(argNum >= 4 && argNum <= 6))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"SNP(npcName,x,y,lr,layerName=default,eventName=default)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSNP", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	const char* layerName = nullptr;
	const char* eventName = nullptr;
	switch (argNum)
	{
	case 6:
		eventName = lua_tostring(L, 6);
	case 5:
		layerName = lua_tostring(L, 5);
		break;
	}
	cmd->SNP(lua_tostring(L, 1),
		(int)lua_tointeger(L, 2),
		(int)lua_tointeger(L, 3),
		(int)lua_tointeger(L, 4),
		layerName,
		eventName);
	return 0;
}

int Tsc_DNP(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"DNP(eventName)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űDNP", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 0)
		cmd->DNP();
	else
		cmd->DNP(lua_tostring(L, 1));
	return 0;
}

int Tsc_MLP(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1 && argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"MLP(val,playerIndex = all)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űMLP", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->MLP((int)lua_tointeger(L, 1));
	else if (argNum == 2)
		cmd->MLP((int)lua_tointeger(L, 1), (int)lua_tointeger(L, 2));
	return 0;
}

int Tsc_ECJ(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"ECJ(eventName)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űECJ", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	lua_pushboolean(L, cmd->ECJ(lua_tostring(L, 1)));
	return 1;
}

int Tsc_LIP(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1 && argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"LIP(val,playerIndex = all)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űLIP", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->LIP((int)lua_tointeger(L, 1));
	else if (argNum == 2)
		cmd->LIP((int)lua_tointeger(L, 1), (int)lua_tointeger(L, 2));
	return 0;
}

int Tsc_MIP(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1 && argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"MIP(val,playerIndex = all)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űMIP", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->MIP((int)lua_tointeger(L, 1));
	else if (argNum == 2)
		cmd->MIP((int)lua_tointeger(L, 1), (int)lua_tointeger(L, 2));
	return 0;
}

int Tsc_TGR(lua_State* L)
{
	LUAGETCMD;
	lua_pushstring(L, cmd->TGR());
	return 1;
}

int Tsc_ELT(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum > 3)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"ELT([npcName[,eventName[,triggerType]]])\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űELT", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	switch (argNum)
	{
	case 0:
		cmd->ELT();
		break;
	case 1:
		cmd->ELT(lua_tostring(L, 1));
		break;
	case 2:
		cmd->ELT(lua_tostring(L, 1), lua_tostring(L, 2), nullptr);
		break;
	case 3:
		cmd->ELT(lua_tostring(L, 1), lua_tostring(L, 2), lua_tostring(L, 3));
		break;
	}
	return 0;
}

int Tsc_SPL(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"SPL(playerIndex,globalEntityID)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSPL", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	cmd->SPL((int)lua_tointeger(L, 1), lua_tostring(L, 2));
	return 0;
}

int Tsc_SGP(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 5)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"SGP(npcName,x,y,lr,globalEntityID)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSGP", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	cmd->SGP(lua_tostring(L, 1),
		(int)lua_tointeger(L, 2),
		(int)lua_tointeger(L, 3),
		(int)lua_tointeger(L, 4),
		lua_tostring(L, 5));
	return 0;
}

int Tsc_CGP(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"CGP(srcGlobalEntityID,dstGlobalEntityID)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űCGP", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	cmd->CGP(lua_tostring(L, 1), lua_tostring(L, 2));
	return 0;
}

int Tsc_DGP(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"DGP(globalEntityID)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űDGP", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	cmd->DGP(lua_tostring(L, 1));
	return 0;
}

int Tsc_AGP(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (!(argNum == 2 || argNum == 3))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"AGP(globalEntityID,enableAI[,followID])\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űAGP", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 2)
		cmd->AGP(lua_tostring(L, 1), lua_toboolean(L, 2));
	else if (argNum == 3)
		cmd->AGP(lua_tostring(L, 1), lua_toboolean(L, 2), lua_tostring(L, 3));
	return 0;
}

int Tsc_P2A(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"P2A(enable=true)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űP2A", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 0)
		cmd->P2A(true);
	else
		cmd->P2A(lua_toboolean(L, 1));
	return 0;
}

int Tsc_WET(lua_State* L)
{
	LUAGETCMD;
	lua_pushboolean(L, cmd->WET());
	return 1;
}

int Tsc_EID(lua_State* L)
{
	LUAGETCMD;
	lua_pushstring(L, cmd->EID());
	return 1;
}

int Tsc_RGI(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 5)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"RGI(regID,iconEntityName,\nfunctionName,checkFunctionName,stackable)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űRGI", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	auto regID = lua_tostring(L, 1);
	auto itemEntityName = lua_tostring(L, 2);
	auto functionName = lua_tostring(L, 3);
	auto checkFunctionName = lua_tostring(L, 4);
	bool stackable = lua_toboolean(L, 5);
	cmd->RGI(regID, itemEntityName, functionName, checkFunctionName, stackable);
	return 0;
}

int Tsc_ITP(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1 && argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"ITP(regID,num=1)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űITP", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		lua_pushinteger(L, cmd->ITP(lua_tostring(L, 1), 1));
	else if(argNum == 2)
		lua_pushinteger(L, cmd->ITP(lua_tostring(L, 1), (int)lua_tointeger(L, 2)));
	return 1;
}

int Tsc_ITS(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum > 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"ITS(regID,num=-1)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űITS", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 0)
		lua_pushinteger(L, cmd->ITS());
	else if (argNum == 1)
		lua_pushinteger(L, cmd->ITS(lua_tostring(L, 1), -1));
	else if (argNum == 2)
		lua_pushinteger(L, cmd->ITS(lua_tostring(L, 1), (int)lua_tointeger(L, 2)));
	return 1;
}

int Tsc_ITJ(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (!(argNum == 1 || argNum == 2))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"ITJ(regID,num=1)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űITJ", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		lua_pushboolean(L, cmd->ITJ(lua_tostring(L, 1), 1));
	else if (argNum == 2)
		lua_pushboolean(L, cmd->ITJ(lua_tostring(L, 1), (int)lua_tointeger(L, 2)));
	return 1;
}

int Tsc_ITC(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"ITC(regID)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űITC", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	lua_pushinteger(L, cmd->ITC(lua_tostring(L, 1)));
	return 1;
}

int Tsc_RGM(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 5)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"RGM(regID,iconEntityName,missionName,functionName,checkFunctionName)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űRGM", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	auto regID = lua_tostring(L, 1);
	auto iconEntityName = lua_tostring(L, 2);
	auto missionName = lua_tostring(L, 3);
	auto functionName = lua_tostring(L, 4);
	auto checkFunctionName = lua_tostring(L, 5);
	cmd->RGM(regID, iconEntityName, missionName, functionName, checkFunctionName);
	return 0;
}

int Tsc_MSA(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"MSA(regID)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űMSA", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	cmd->MSA(lua_tostring(L, 1));
	return 0;
}

int Tsc_MSD(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (!(argNum == 0 || argNum == 1))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"MSD(regID)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űMSD", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 0)
		cmd->MSD();
	else if (argNum == 1)
		cmd->MSD(lua_tostring(L, 1));
	return 0;
}

int Tsc_MSR(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"MSR(regID_src,regID_dst)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űMSR", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	cmd->MSR(lua_tostring(L, 1), lua_tostring(L, 2));
	return 0;
}

int Tsc_MSJ(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"MSJ(regID)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űMSJ", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	lua_pushboolean(L, cmd->MSJ(lua_tostring(L, 1)));
	return 1;
}

int Tsc_SUB(lua_State* L)
{
	LUAGETCMD_SUB;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"SUB(bSub=false)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSUB", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 0)
		cmd->SUB(false);
	else
		cmd->SUB(lua_toboolean(L, 1));
	return 0;
}

int Tsc_LOC(lua_State* L)
{
	LUAGETCMD_SUB;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"LOC(bLock)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űLOC", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 0)
	{
		lua_pushboolean(L, mainGameCmd->LOC(cmd->GetCheckItemIndex()));
		return 1;
	}
	else
	{
		mainGameCmd->LOC(cmd->GetCheckItemIndex(), lua_toboolean(L, 1));
		return 0;
	}
}

int Tsc_GIT(lua_State* L)
{
	auto argNum = lua_gettop(L);
	if (argNum > 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"GIT(regID,num=1)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űGIT", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 0)
		mainGameCmd->GIT();
	else if (argNum == 1)
		mainGameCmd->GIT(lua_tostring(L, 1), 1);
	else if (argNum == 2)
		mainGameCmd->GIT(lua_tostring(L, 1), (int)lua_tointeger(L, 2));
	return 0;
}

int Tsc_IMM(lua_State* L)
{
	mainGameCmd->IMM();
	return 0;
}

int Tsc_SKP(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"SKP(flagName)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSKP", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	cmd->SKP(lua_tostring(L, 1));
	return 0;
}

int Tsc_SKS(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"SKS(flagName)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSKS", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	cmd->SKS(lua_tostring(L, 1));
	return 0;
}

int Tsc_SKJ(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"SKJ(flagName)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSKJ", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	bool bExist = cmd->SKJ(lua_tostring(L, 1));
	lua_pushboolean(L, bExist);
	return 1;
}

int Tsc_POS(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"POS(bSave=false)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űPOS", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 0)
		cmd->POS();
	else if (argNum == 1)
		cmd->POS(lua_toboolean(L, 1));
	return 0;
}

int Tsc_CMP(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (!(argNum == 2 || argNum == 3))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"CMP(layerNameCopyFrom,layerNameCopyTo[,smokeNpcName])\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űCMP", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 2)
		cmd->CMP(lua_tostring(L, 1), lua_tostring(L, 2));
	if (argNum == 3)
		cmd->CMP(lua_tostring(L, 1), lua_tostring(L, 2), lua_tostring(L, 3));
	return 0;
}

int Tsc_QUA(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (!(argNum == 1 || argNum == 2))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"QUA(times,mode=0)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űQUA", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		cmd->QUA((int)lua_tointeger(L, 1), 0);
	else if (argNum == 2)
		cmd->QUA((int)lua_tointeger(L, 1), (int)lua_tointeger(L, 2));
	return 0;
}

int Tsc_SWC(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (!(argNum == 3 || argNum == 4))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"SWC(playerIndex,npcName,globalEntityID,extendHpMax=false)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSWC", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 3)
		cmd->SWC((int)lua_tointeger(L, 1), lua_tostring(L, 2), lua_tostring(L, 3), false);
	else if (argNum == 4)
		cmd->SWC((int)lua_tointeger(L, 1), lua_tostring(L, 2), lua_tostring(L, 3), lua_toboolean(L, 4));
	return 0;
}

int Tsc_SWP(lua_State* L)
{
	LUAGETCMD;
	cmd->SWP();
	return 0;
}

int Tsc_MCN(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"MCN(playerIndex)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űMCN", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	lua_pushstring(L, cmd->MCN((int)lua_tointeger(L, 1)));
	return 1;
}

int Tsc_MCI(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"MCI(mycharName)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űMCI", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	lua_pushinteger(L, cmd->MCI(lua_tostring(L, 1)));
	return 1;
}

int Tsc_GOP(lua_State* L)
{
	LUAGETCMD;
	lua_pushinteger(L, cmd->GOP());
	return 1;
}

int Tsc_FLA(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"FLA(times=20)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űFLA", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 0)
		cmd->FLA();
	else
		cmd->FLA((int)lua_tointeger(L, 1));
	return 0;
}

int Tsc_KIL(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (!(argNum == 1 || argNum == 2))
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"KIL(npcName,damage=9999)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űKIL", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 1)
		lua_pushinteger(L, cmd->KIL(lua_tostring(L, 1)));
	else if (argNum == 2)
		lua_pushinteger(L, cmd->KIL(lua_tostring(L, 1), (int)lua_tointeger(L, 2)));
	return 1;
}

int Tsc_STA(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 3)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"STA(smokeNpcName,num,soundName)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űSTA", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	cmd->STA(lua_tostring(L, 1), (int)lua_tonumber(L, 2), lua_tostring(L, 3));
	return 0;
}

int Tsc_ZAM(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"ZAM(playerIndex)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űZAM", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 0)
		cmd->ZAM();
	else if (argNum == 1)
		cmd->ZAM((int)lua_tointeger(L, 1));
	return 0;
}

int Tsc_RST(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	std::vector<std::wstring> nameArr;
	std::vector<wchar_t> wbuff;
	for (int i = 0; i < argNum; i++)
	{
		UTF8ToUTF16(lua_tostring(L, i + 1), &wbuff);
		nameArr.push_back(wbuff.data());
	}
	cmd->RST(nameArr);
	return 0;
}

int Tsc_CRE(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum > 1)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"CRE(creditName)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űCRE", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	if (argNum == 0)
		cmd->CRE();
	else
		cmd->CRE(lua_tostring(L, 1));
	return 0;
}

int Tsc_KEN(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"KEN(playerIndex,keyIndex)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űKEN", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	lua_pushstring(L, cmd->KEN((int)lua_tointeger(L, 1), (int)lua_tointeger(L, 2)));
	return 1;
}

int Tsc_DIF(lua_State* L)
{
	LUAGETCMD;
	lua_pushinteger(L, cmd->DIF());
	return 1;
}

int Tsc_TIM(lua_State* L)
{
	LUAGETCMD;
	//ȡ
	auto argNum = lua_gettop(L);
	if (argNum != 2)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"TIM(visiable,start)\nʵյΪ%d", argNum);
		MessageBoxW(hwnd, err, L"űTIM", MB_OK | MB_ICONWARNING);
		exit(0);
	}
	cmd->TIM((bool)lua_toboolean(L, 1), (bool)lua_toboolean(L, 2));
	return 0;
}

int Tsc_STC(lua_State* L)
{
	LUAGETCMD;
	lua_pushboolean(L, cmd->STC());
	return 1;
}

int Tsc_LTC(lua_State* L)
{
	LUAGETCMD;
	lua_pushboolean(L, cmd->LTC());
	return 1;
}
