// Compute Shader: INTER_AREA ͼС
Texture2D<float4> InputTexture : register(t0); // 
RWTexture2D<float4> OutputTexture : register(u0); // 

[numthreads(16, 16, 1)]
void CSMain(uint3 id : SV_DispatchThreadID)
{
   // ȡͼĳߴ
    uint outputWidth, outputHeight;
    OutputTexture.GetDimensions(outputWidth, outputHeight);

    // ȡͼĳߴ
    uint inputWidth, inputHeight;
    InputTexture.GetDimensions(inputWidth, inputHeight);

    // ű
    float scaleW = float(inputWidth) / float(outputWidth);
    float scaleH = float(inputHeight) / float(outputHeight);

    // 㵱ǰضӦ
    float srcX = id.x * scaleW;
    float srcY = id.y * scaleH;
    float srcXEnd = (id.x + 1) * scaleW;
    float srcYEnd = (id.y + 1) * scaleH;

    // ı߽
    uint xStart = uint(srcX);
    uint yStart = uint(srcY);
    uint xEnd = uint(srcXEnd);
    uint yEnd = uint(srcYEnd);

    // ߽
    xStart = max(0, min(xStart, inputWidth - 1));
    yStart = max(0, min(yStart, inputHeight - 1));
    xEnd = max(0, min(xEnd, inputWidth - 1));
    yEnd = max(0, min(yEnd, inputHeight - 1));

    // ڵܺ
    float4 sum = float4(0, 0, 0, 0);
    uint count = 0;

    for (uint yi = yStart; yi < yEnd; ++yi)
    {
        for (uint xi = xStart; xi < xEnd; ++xi)
        {
            sum += InputTexture[uint2(xi, yi)];
            count++;
        }
    }
     // ƽֵ
    float4 avg = count == 0 ? InputTexture[uint2(xStart, yStart)] : sum / float(count);
    // д
    OutputTexture[id.xy] = avg;
}