#include "CPidEditorGrid.h"
#include "resource.h"

IMPLEMENT_DYNAMIC(CPidEditorGrid, CDialog)

BEGIN_MESSAGE_MAP(CPidEditorGrid, CDialog)
	ON_BN_CLICKED(IDOK, &CPidEditorGrid::OnBnClickedOk)
END_MESSAGE_MAP()

CPidEditorGrid::CPidEditorGrid(CWnd* pParent)
	: CDialog(IDD_CPIDEDITOR_GRID, pParent)
{
}

CPidEditorGrid::~CPidEditorGrid()
{
}

void CPidEditorGrid::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_GRID_W, edit_grid_w);
	DDX_Control(pDX, IDC_EDIT_GRID_H, edit_grid_h);
	DDX_Control(pDX, IDC_EDIT_COUNT_W, edit_count_w);
	DDX_Control(pDX, IDC_EDIT_MAX_ID, edit_max_id);
	DDX_Control(pDX, IDC_EDIT_TILE_W, edit_tile_w);
	DDX_Control(pDX, IDC_EDIT_TILE_H, edit_tile_h);
	DDX_Control(pDX, IDC_CHECK_INTERAREA, check_interArea);
}

BOOL CPidEditorGrid::OnInitDialog()
{
	CDialog::OnInitDialog();
	SetDlgItemInt(IDC_EDIT_GRID_W, outGridW);
	SetDlgItemInt(IDC_EDIT_GRID_H, outGridH);
	SetDlgItemInt(IDC_EDIT_COUNT_W, outCountW);
	SetDlgItemInt(IDC_EDIT_MAX_ID, outMaxID);
	SetDlgItemInt(IDC_EDIT_TILE_W, outTileW);
	SetDlgItemInt(IDC_EDIT_TILE_H, outTileH);
	check_interArea.SetCheck(outInterArea ? 1 : 0);
	return 0;
}

void CPidEditorGrid::OnBnClickedOk()
{
	
	int grid_w = GetDlgItemInt(IDC_EDIT_GRID_W);
	if (grid_w < 1)
	{
		MessageBox(L"ԪߴȲС1", L"дЧ");
		return;
	}

	int grid_h = GetDlgItemInt(IDC_EDIT_GRID_H);
	if (grid_h < 1)
	{
		MessageBox(L"Ԫߴ߶ȲС1", L"дЧ");
		return;
	}

	int count_w = GetDlgItemInt(IDC_EDIT_COUNT_W);
	if (count_w < 1)
	{
		MessageBox(L"ÿҪʾС1", L"дЧ");
		return;
	}

	int count_max = GetDlgItemInt(IDC_EDIT_MAX_ID);
	if (count_max < 1)
	{
		MessageBox(L"С1", L"дЧ");
		return;
	}

	int tile_w = GetDlgItemInt(IDC_EDIT_TILE_W);
	if (tile_w < 1)
	{
		MessageBox(L"ÿƬؿȲС1", L"дЧ");
		return;
	}

	int tile_h = GetDlgItemInt(IDC_EDIT_TILE_H);
	if (tile_h < 1)
	{
		MessageBox(L"ÿƬظ߶ȲС1", L"дЧ");
		return;
	}
	outGridW = grid_w;
	outGridH = grid_h;
	outCountW = count_w;
	outMaxID = count_max;
	outTileW = tile_w;
	outTileH = tile_h;
	outInterArea = check_interArea.GetCheck();
	CDialog::OnOK();
}
