#pragma once
#include "global.h"
#include "CMyListBox.h"
#include "CPidEditorDraw.h"
#include "CPidEditorBrush.h"
#include "CAniEditor.h"
#define CPIDEDITOR_MENUINDEX_FILE 0
#define CPIDEDITOR_MENUINDEX_EDIT 1
#define CPIDEDITOR_MENUINDEX_OPTION 2
#define CPIDEDITOR_MENUINDEX_WINDOW 3
#define CPIDEDITOR_DATATYPE_PID_STR "std::unordered_map<int, MyRect>"
#define CPIDEDITOR_DATATYPE_PID std::unordered_map<int, MyRect>
//Pid༭
class CPidEditor : public CDialog
{
	DECLARE_DYNAMIC(CPidEditor)
	DECLARE_MESSAGE_MAP()
public:
	CPidEditor(CWnd* pParent = nullptr);   // ׼캯
	virtual ~CPidEditor();
	// Ի
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_CPIDEDITOR };
#endif
	void* pMainEditor = nullptr;
	//
	bool showGrid = false;//ʾ
	bool showBk = false;//ʾ͸
	bool showID = false;//ʾid
	//ͼ
	int pid_tile_w = 16;
	int pid_tile_h = 16;
	bool bInterArea = false;//ǷԲ
	int lineShow = 16;//ÿʾ
	void Draw();//
	void Load(CString filename);//ļ
	void Save();//
	bool Close();
	CPIDEDITOR_DATATYPE_PID* GetStep();
	void UpdateMenuState();//²˵״̬
	void UpdateWindowTitle();//´ڱ
	bool CheckSaved();
	bool IsLoaded();
	void ResetContext();
	CString GetPngFile();
	MyUndoRedo* GetMyUndoRedo();
	void XMLLoad(CString xml);
	CString XMLSaved();
	CString GetPidFile();
	void SetAni(int id);//ö
	void AniIDSetRect(int id, MyRect* rc);
	bool IsBrushWndShow();
	bool IsAniWndShow();
	////////////////////ȼ//////////////////
	HACCEL hAccel = nullptr;//ȼ
	BOOL PreTranslateMessage(MSG* pMsg) override;
protected:
	void DoDataExchange(CDataExchange* pDX) override;
	BOOL OnInitDialog() override;
	void OnCancel() override;
	void OnEnterKey();//պ ֹس˳
public:
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnMoving(UINT fwSide, LPRECT pRect);
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnEditPid();
	afx_msg void OnEditPng();
	afx_msg void OnOpenFolder();
	afx_msg void OnUpdateList();
	afx_msg void OnOpenFile();
	afx_msg void OnSaveFile();
	afx_msg void OnCloseFile();
	afx_msg void OnUndo();
	afx_msg void OnRedo();
	afx_msg void OnCopy();
	afx_msg void OnPaste();
	afx_msg void OnCut();
	afx_msg void OnShowBk();
	afx_msg void OnShowGrid();
	afx_msg void OnGridSetting();
	afx_msg void OnShowId();
	afx_msg void OnBrushWnd();
	afx_msg void OnAniEditor();
	afx_msg void OnResetWndPos();
	afx_msg void OnLbnDblclkListPnglist();
	afx_msg void OnSwitchLanguage();
	afx_msg void OnPidShowUsing();
	afx_msg void OnNextframe();
	afx_msg void OnPrevframe();
private:
	//ؼ
	CStatic* static_pngList;
	CMyListBox listbox_pngList;
	CStatic* static_idEditor;
	//Ӵ
	CPidEditorDraw pDrawWnd;
	CPidEditorBrush pBrushWnd;
	CAniEditor pAniWnd;
	//
	CString pngfile;
	CString pidfile;
	int pid_tile_w_saved = 16;
	int pid_tile_h_saved = 16;
	bool bInterArea_saved = false;//ǷԲ
	int lineShow_saved = 16;//ÿʾ
	//
	MyUndoRedo undoRedo;
	CPIDEDITOR_DATATYPE_PID saved;

	//ճ
	MyRect rcCopy;
	void StepCopyToSaved();
	//Ŀ¼
	CString languageSel;
};

