#include "CNewMap.h"
#include "resource.h"

IMPLEMENT_DYNAMIC(CNewMap, CDialog)

BEGIN_MESSAGE_MAP(CNewMap, CDialog)
	ON_BN_CLICKED(IDOK, &CNewMap::OnBnClickedOk)
END_MESSAGE_MAP()

CNewMap::CNewMap(CWnd* pParent)
	: CDialog(IDD_CMAPEDITOR_NEWMAP, pParent)
{
}

CNewMap::~CNewMap()
{
}

void CNewMap::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_MAPFILE, edit_mapFile);
	DDX_Control(pDX, IDC_EDIT_MAPNAME, edit_mapName);
	DDX_Control(pDX, IDC_EDIT_MAP_W, edit_mapW);
	DDX_Control(pDX, IDC_EDIT_MAP_H, edit_mapH);
}

BOOL CNewMap::OnInitDialog()
{
	CDialog::OnInitDialog();
	//ÿؼʼֵ
	if (load)
	{
		SetWindowText(L"༭ͼ");
		edit_mapFile.SetWindowTextW(outMapFile.GetString());
		edit_mapName.SetWindowTextW(outMapName.GetString());
	}
	SetDlgItemInt(IDC_EDIT_MAP_W, outMapW);
	SetDlgItemInt(IDC_EDIT_MAP_H, outMapH);
	return 0;
}


void CNewMap::OnBnClickedOk()
{
	// TODO: ڴӿؼ֪ͨ
	CString mapFile;
	edit_mapFile.GetWindowTextW(mapFile);
	if (mapFile.GetLength() == 0)
	{
		MessageBoxW(L"дͼļ", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	if (!load || 
		(load && outMapFile != mapFile))
	{
		//Ƿ޸ļ
		//鱾mapĿ¼Ƿͬͼļ
		CString pxmfile;
		pxmfile.Format(L"./data/map/%s.pxm", mapFile.GetString());
		FILE* fp;
		_wfopen_s(&fp, pxmfile.GetString(), L"rb");
		if (fp)
		{
			fclose(fp);
			//pxmļ
			CString err;
			err.Format(L"ͬͼļ%s", pxmfile.GetString());
			MessageBoxW(err.GetString(), L"дϢЧ", MB_ICONINFORMATION);
			return;
		}
		//űļ
		CString luafile;
		luafile.Format(L"./data/map/%s.lua", mapFile.GetString());
		if (fp)
		{
			fclose(fp);
			//luaļ
			CString err;
			err.Format(L"ͬͼļ%s", luafile.GetString());
			MessageBoxW(err.GetString(), L"дϢЧ", MB_ICONINFORMATION);
			return;
		}
	}
	CString mapName;
	edit_mapName.GetWindowTextW(mapName);
	CString mapW;
	edit_mapW.GetWindowTextW(mapW);
	if (mapW.GetLength() == 0)
	{
		MessageBoxW(L"дͼ", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	if (GetDlgItemInt(IDC_EDIT_MAP_W) > 0xffff)
	{
		MessageBoxW(L"ͼȳ65535", L"дϢЧ", MB_ICONINFORMATION);
		return;
	}
	CString mapH;
	edit_mapH.GetWindowTextW(mapH);
	if (mapH.GetLength() == 0)
	{
		MessageBoxW(L"дͼ߶", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	if (GetDlgItemInt(IDC_EDIT_MAP_H) > 0xffff)
	{
		MessageBoxW(L"ͼ߶ȳ65535", L"дϢЧ", MB_ICONINFORMATION);
		return;
	}
	//
	outMapFile = mapFile;
	outMapName = mapName;
	outMapW = GetDlgItemInt(IDC_EDIT_MAP_W);
	outMapH = GetDlgItemInt(IDC_EDIT_MAP_H);
	CDialog::OnOK();
}
