#include "PeReadyBar.h"

PeReadyBar::PeReadyBar(std::shared_ptr<Entity> parent, float* pVal, DWORD color, float dx, float dy, 
	bool (*LeaveFunc)(std::weak_ptr<Entity> e), void (*DestoryFunc)(std::weak_ptr<Entity> e))
{
	type = 3;
	attackParent = parent;
	this->pVal = pVal;
	this->color = color;
	this->dx = dx;
	this->dy = dy;
	this->LeaveFunc = LeaveFunc;
	this->DestoryFunc = DestoryFunc;
	topDraw = true;
}

void PeReadyBar::Step()
{
	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		x = wattackParent->x + dx;
		y = wattackParent->y + dy;
		last_x = wattackParent->last_x + dx;
		last_y = wattackParent->last_y + dy;
	}
	if (!leave)
		leave = LeaveFunc(attackParent);
	if (fadeInAlpha + 0.05f < 1)
		fadeInAlpha += 0.05f;
	if (leave)
	{
		fadeOutAlpha -= 0.05f;
		if (fadeOutAlpha <= 0)
			Destroy();
	}
	SetShape();
}

void PeReadyBar::DeltaTime(float deltaTime)
{
	//λ
	if (lineList.size() < lineList_set_last.size())
		lineList.resize(lineList_set_last.size());
	for (int i = 0; i < lineList_set_last.size(); i++)
	{
		auto& dst = lineList[i];
		auto& src_last = lineList_set_last[i];
		auto& src = lineList_set[i];
		dst.x = lerp(src_last.x, src.x, deltaTime);
		dst.y = lerp(src_last.y, src.y, deltaTime);
		dst.c = src.c;
	}
	if (fillList.size() < fillList_set_last.size())
		fillList.resize(fillList_set_last.size());
	for (int i = 0; i < fillList_set_last.size(); i++)
	{
		auto& dst = fillList[i];
		auto& src_last = fillList_set_last[i];
		auto& src = fillList_set[i];
		dst.x = lerp(src_last.x, src.x, deltaTime);
		dst.y = lerp(src_last.y, src.y, deltaTime);
		dst.c = src.c;
	}
	Entity::DeltaTime(deltaTime);
}

void PeReadyBar::Destroy()
{
	if (DestoryFunc)
		DestoryFunc(attackParent);
	Entity::Destroy();
}

void PeReadyBar::SetShape()
{
	lineList_set_last.swap(lineList_set);
	fillList_set_last.swap(fillList_set);
	MyRGBA myRGBA;
	myRGBA.Set(color);
	myRGBA.a = (UINT8)(myRGBA.a * fadeInAlpha * fadeOutAlpha);
	DWORD c = myRGBA.Get();
	AddRect(lineList_set, 0, -10, -1, 10, 2, c, c, c, c);
	AddFillRect(fillList_set, 0, -10, -1, -10 + 20 * *pVal, 2, c, c, c, c);
}
