#include "PeSnowflake.h"

PeSnowflake::PeSnowflake()
{
	type = 3;
	//ö
	ani.png = L"pe_effect_obj";
	ani.sprite_index = L"snowflake";
	//ͼ
	int val = Random(0, 100);
	if (val <= 50)
	{
		ani.image_index = 0;
		cbRect.left = 1;
		cbRect.top = 1;
		cbRect.right = 0;
		cbRect.bottom = 0;
	}
	else if (val <= 90)
	{
		ani.image_index = 1;
		cbRect.left = 2;
		cbRect.top = 2;
		cbRect.right = 1;
		cbRect.bottom = 1;
	}
	else
	{
		ani.image_index = 2;
		cbRect.left = 3;
		cbRect.top = 3;
		cbRect.right = 2;
		cbRect.bottom = 2;
	}
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//
	action_timecounter_max = 60;
	action_timecounter = action_timecounter_max;
}

void PeSnowflake::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateGravity.SetGravityScale(0.2f);
	Entity::Init(self);
}

void PeSnowflake::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//
	stateGravity.Step();
	//
	vx /= 1.1f;
	if (vy < 0)
		vy /= 1.1f;
	//ʧ
	if (cbRect.cbBottom)
		leave = true;
	if (leave)
	{
		if (action_timecounter > 0)
		{
			action_timecounter--;
			if (action_timecounter == 0)
				Destroy();
		}
	}
	color = RGBA(0xff, 0xff, 0xff, BYTE(action_timecounter * 0xff / action_timecounter_max));
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//ִ˶
	Entity::Step();
	//һײ
	Entity::ClearCollisionResult();
	//ִײ
	Entity::Collision();
}

void SetPeSnowflakeExplode(std::shared_ptr<Entity> parent, float x, float y, int nMin, int nMax)
{
	if (nMin > nMax)
	{
		int temp = nMax;
		nMax = nMin;
		nMin = temp;
	}
	int num = Random(nMin, nMax);
	for (int i = 0; i < num; i++)
	{
		auto pe = std::make_shared<PeSnowflake>();
		pe->x = x;
		pe->y = y;
		//ٶ
		float speed = 0x800 / ts;
		float angle = (float)Random(180, 360);
		pe->vx = speed * cosf(angle);
		pe->vy = speed * sinf(angle);
		parent->gameFunc->SetEntity(parent, pe);
	}
}
