#include "PeRain.h"
#include "PeRainDrip.h"

PeRain::PeRain()
{
}

void PeRain::Step()
{
	if (interval_counter > 0)
		interval_counter--;
	else
	{
		interval_counter = Random(0, 2);
		auto e = std::make_shared<PeRainDrip>();
		e->rain = shared_from_this();
		e->y = -16;
		e->x = (float)(Random(0, (int)(x - 1)));
		e->SetState(0, lr);
		gameFunc->SetEntity(shared_from_this(), e);
	}
}

void PeRain::SetState(int stateID, int lr)
{
	mode = stateID;
	this->lr = lr;
}

std::shared_ptr<Entity> CreatePeRain()
{
	return std::make_shared<PeRain>();
}
