#include "PeLightPx.h"

PeLightPx::PeLightPx()
{
	//
	type = 3;
	//ʼ
	A = (float)(Random(0, 1) == 0 ? 1 : -1);
	B = (float)(Random(0, 8));
	C = (float)Random(0, 7) / 10.0f;
	D = (float)Random(0, 6);
	//ͼ
	ani.png = L"water";
	ani.sprite_index = L"lightPx";
	action_timecounter = 128;
	action_timecounter_start = action_timecounter;
}

void PeLightPx::Step()
{
	//ִ˶
	Entity::Step();
	x += A * B * (sinf(angle * deg2rad) - sinf((angle + D) * deg2rad));
	y -= C;
	angle += D;
	int alpha = 0xff * action_timecounter / (action_timecounter_start / 2);
	if (alpha > 0xff)
		alpha = 0xff;
	color = RGBA(0xff, 0xff, 0xff, (UINT8)alpha);
	if (action_timecounter > 0)
		action_timecounter--;
	else
		Destroy();
}

std::shared_ptr<Entity> CreatePeLightPx()
{
	return std::make_shared<PeLightPx>();
}
