#include "CS_TestBat.h"

CS_TestBat::CS_TestBat()
{
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 4;
	cbRect.top = 7;
	cbRect.bottom = 4;
	ani.hideLayerList.insert(1);
	ani.hideLayerList.insert(2);
	ani.hideLayerList.insert(3);
}

void CS_TestBat::Init(std::weak_ptr<Entity> self)
{
	srcX = x;
	srcY = y;
	Entity::Init(self);
}

void CS_TestBat::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		count1 = 120;
		act_no = 1;
		act_wait = Random(0, 50);
		[[fallthrough]];
	case 1:
		if (++act_wait < 50)
			break;
		act_wait = 0;
		act_no = 2;
		vy = 0x1000 / ts;
		break;
	case 2:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				lr = wplayer->x < x ? 0 : 1;
			}
		}
		if (srcY < y)
			vy -= 0x100 / ts;
		if (srcY > y)
			vy += 0x100 / ts;
		if (vy > 0x4000 / ts)
			vy = 0x4000 / ts;
		if (vy < -0x4000 / ts)
			vy = -0x4000 / ts;
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	if (++ani_wait > 1)
	{
		ani_wait = 0;
		++ani_no;
	}
	if (ani_no > 2)
		ani_no = 0;
	ani.sprite_index = lr == 0 ? L"ls_bat_fly_l" : L"ls_bat_fly_r";
}

std::shared_ptr<Entity> CreateCS_TestBat()
{
	return  std::make_shared<CS_TestBat>();
}
