#include "CS_SoapKingAni.h"

CS_SoapKingAni::CS_SoapKingAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 12;
	cbRect.top = 8;
	cbRect.bottom = 8;
	drawBeforeOtherEntity = true;
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(1);
}

void CS_SoapKingAni::Step()
{
	switch (stateID)
	{
	case 0://վ
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_SoapKingAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	if (stateID < 1000)
	{
		this->stateID = stateID;
		switch (stateID)
		{
		case 0:
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_soapking_stand_l" : L"mc_soapking_stand_r";
			if (bArgInit)
			{
				bArgInit = false;
				if (el.arg.length())
					SetState(el.arg, lr);
			}
			break;
		case 1://·
			{
				animation_delay = true;
				if (lr == 0)
					vx = -animation_moveSpeed;
				else
					vx = animation_moveSpeed;
				ani.sprite_index = lr == 0 ? L"mc_soapking_move_l" : L"mc_soapking_move_r";
			}
			break;
		case 2://
			ani.hideLayerList.erase(0);
			ani.hideLayerList.erase(1);
			ani.sprite_index = lr == 0 ? L"mc_soapking_defeated_l" : L"mc_soapking_defeated_r";
			break;
		}
	}
}

void CS_SoapKingAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"walk")
		SetState(1, lr);
	else if (stateName == L"show_crown")
	{
		ani.hideLayerList.erase(0);
		ani.hideLayerList.erase(1);
	}
	else if (stateName == L"defeated")
		SetState(2, lr);
	else if (stateName == L"hide_wand")
		ani.hideLayerList.insert(1);
}

std::shared_ptr<Entity> CreateCS_SoapKingAni()
{
	return std::make_shared<CS_SoapKingAni>();
}
