#include "CS_SantaFireball.h"
#include "CS_Santa.h"
const int CS_SantaSTATENAME_FIREBALL = GetNextEntityStateID();
CS_SantaFireball::CS_SantaFireball()
{
	stateID = CS_SantaSTATENAME_FIREBALL;
	cd_counter = 0;
	cd_counter_max = 1;
	iconIndex = 0;
}

const wchar_t* CS_SantaFireball::GetSaveName()
{
	return L"Fireball";
}

void CS_SantaFireball::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Santa>(we);
	bool a1 = !lock;
	bool b1 = (mychar->input.key & keyMask);
	bool c1 = cd_counter == 0 && mychar->mp >= mp_cost;

	bool a = a1;
	bool b = b1;
	bool c = c1;
	if (a && b && c)
	{
		mychar->lastSkill = this;
		mychar->ChangeState(GetStateID());
	}
	//ȴʱ
	if (cd_counter > 0)
		cd_counter--;
	//ȼ
	if (mychar->mp >= 30)
		level = 2;
	else if (mychar->mp >= 10)
		level = 1;
	else
		level = 0;
	//ҪUI
}

void CS_SantaFireball::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID() &&
		(
			(level == 0 && amList.size() < 2) ||
			(level == 1 && amList.size() < 3) || 
			(level == 2 && amList.size() < 4)
		))
	{
		//ʼ
		auto we = e.lock();
		if (!we)
			return;
		auto mychar = std::static_pointer_cast<CS_Santa>(we);
		enable = false;
		//
		int targetLevel = level;
		//һֱάֻ3̬
		if (mychar->skillGhostFire.lock == false)
			targetLevel = 2;
		auto am = std::make_shared<CS_SantaFireballBlade>(we, targetLevel);
		we->gameFunc->SetEntity(we, am);
		amList.push_back(am);
		//ס
		mychar->inputLock.key |= keyMask;
	}
	else
		enable = false;
}
