#include "CS_PuppyAni.h"
#include "CS_PeSmoke.h"
#include "CS_PeZzz.h"

CS_PuppyAni::CS_PuppyAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 4;
	cbRect.top = 6;
	cbRect.bottom = 8;
}

void CS_PuppyAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	Entity::Init(self);
}

void CS_PuppyAni::Step()
{
	switch (stateID)
	{
	case 0://վ
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.hideLayerList.erase(0);
			ani.hideLayerList.insert(1);
		}
		else
		{
			ani.hideLayerList.erase(1);
			ani.hideLayerList.insert(0);
		}
		break;
	case 1://
		vx = 0;
		if (cbRect.cbBottom)
		{
			for (int i = 0; i < 4; i++)
			{
				auto pe = std::make_shared<CS_PeSmoke>();
				pe->x = x + Random(-12, 12);
				pe->y = y + Random(-12, 12);
				pe->vx = Random(-341, 341) / ts;
				pe->vy = Random(-0x600, 0) / ts;
				gameFunc->SetEntity(shared_from_this(), pe);
			}
			gameFunc->PlaySound(L"CS_071_little_crash");
			SetState(2, lr);
		}
		else
		{
			//
			stateGravity.State();
			stateWater();
		}
		break;
	case 2://ſڵ
		if (abs(vx) > 0.001f)
			vx /= 1.05f;
		else
			vx = 0;
		break;
	case 3://ͽ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
			SetState(0, lr);
		break;
	case 4://ƶ
		break;
	case 5://˯
		if (++act_wait > 100)
		{
			act_wait = 0;
			SetPeCS_Zzz(shared_from_this(), x, y);
		}
		if (abs(vx) > 0.001f)
			vx /= 1.05f;
		else
			vx = 0;
		break;
	}
	//糡
	Entity::Wind();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_PuppyAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	ani.hideLayerList.erase(1);
	ani.hideLayerList.insert(0);
	//ö
	switch (stateID)
	{
	case 0://վ
		vx = 0;
		if(bSit)
			ani.sprite_index = lr == 0 ? L"mc_puppy_sit_l" : L"mc_puppy_sit_r";
		else
			ani.sprite_index = lr == 0 ? L"mc_puppy_stand_l" : L"mc_puppy_stand_r";
		break;
	case 1://
		ani.sprite_index = lr == 0 ? L"mc_puppy_hurt_l" : L"mc_puppy_hurt_r";
		break;
	case 2://ſڵ
		ani.sprite_index = lr == 0 ? L"mc_puppy_lie_l" : L"mc_puppy_lie_r";
		break;
	case 3://ͽ
		action_timecounter = 8;
		if (bSit)
			ani.sprite_index = lr == 0 ? L"mc_puppy_sit_barking_l" : L"mc_puppy_sit_barking_r";
		else
			ani.sprite_index = lr == 0 ? L"mc_puppy_stand_barking_l" : L"mc_puppy_stand_barking_r";
		gameFunc->PlaySound(L"CS_105_puppy_bark");
		break;
	case 4://ƶ
		animation_delay = true;
		ani.sprite_index = lr == 0 ? L"mc_puppy_move_l" : L"mc_puppy_move_r";
		vx = lr == 0 ? -animation_moveSpeed : animation_moveSpeed;
		break;
	case 5://˯
		ani.sprite_index = lr == 0 ? L"mc_puppy_lie_l" : L"mc_puppy_lie_r";
		break;
	}
}

void CS_PuppyAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"fall")
		SetState(1, lr);
	else if (stateName == L"lie")
		SetState(2, lr);
	else if (stateName == L"bark")
		SetState(3, lr);
	else if (stateName == L"walk")
		SetState(4, lr);
	else if (stateName == L"sleep")
		SetState(5, lr);
}

void CS_PuppyAni::stateWater()
{
	stateGravity.SetPhysice(cbRect.inWater);
	if (cbRect.pxaBottom == 0x12)
		stateGravity.SetPhysice(true);
	//ˮˮЧ
	if (cbRect.inWater)
	{
		if (fallToWater && setSplash && vy >= stateGravity.max_fall_speed / 2)
		{
			//ˮ
			auto nE = gameFunc->GameCreateEntity(L"pe_splash");
			nE->x = x;
			nE->y = y;
			//ҽ
			if (cbRect.inLava)
				nE->color = RGBA(0xff, 0, 0, 0xff);
			gameFunc->SetEntity(shared_from_this(), nE);
			fallToWater = false;
		}
		else
		{
			//ٶδﵽȻˮ
			setSplash = false;
		}
	}
	else
	{
		//ˮ
		fallToWater = true;
		setSplash = true;
	}
}

std::shared_ptr<Entity> CreateCS_PuppyAni()
{
	return std::make_shared<CS_PuppyAni>();
}
