#include "CS_ProfessorBoosterAni.h"
#include "CS_MagicBubble.h"

CS_ProfessorBoosterAni::CS_ProfessorBoosterAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(2);
}

void CS_ProfessorBoosterAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	Entity::Init(self);
}

void CS_ProfessorBoosterAni::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateGravity.Step();
	switch (stateID)
	{
	case 0:
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		break;
	}
	if (stateID != 1)
	{
		//
		vx = 0;
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
	if (flashcounter > 0)
		flashcounter--;
	if (flashcounter / 2 % 2 == 0)
	{
		shader.usingShader = false;
	}
	else
	{
		shader.usingShader = true;
		shader.ps = shader.vs = L"flash";
	}
}

void CS_ProfessorBoosterAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	//ö
	switch (stateID)
	{
	case 0://վ
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_professorbooster_stand_l" : L"mc_professorbooster_stand_r";
		break;
	case 1://·
		{
			animation_delay = true;
			if (lr == 0)
				vx = -animation_moveSpeed;
			else
				vx = animation_moveSpeed;
			ani.sprite_index = lr == 0 ? L"mc_professorbooster_move_l" : L"mc_professorbooster_move_r";
		}
		break;
	case 2://
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_professorbooster_back_l" : L"mc_professorbooster_back_r";
		break;
	case 3://ʩ
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_professorbooster_magic_l" : L"mc_professorbooster_magic_r";
		break;
	case 4://˸һ
		flashcounter = 30;
		break;
	}
}

void CS_ProfessorBoosterAni::SetState(std::wstring stateName, int lr)
{
	if (bSetTarget)
	{
		bSetTarget = false;
		std::shared_ptr<Entity> wtarget;
		auto& allRes = *gameFunc->GetLoadedEntity(gameFunc->entityRes);
		EntityLayer* eLayer = nullptr;
		for (auto& res : allRes)
		{
			if (res.first->layerType == 0)
			{
				eLayer = &res.second;
				break;
			}
		}
		if (eLayer)
		{
			bool bFound = false;
			//ȫʵѰ
			auto& allPlayer = *gameFunc->GetGlobalEntityTable(gameFunc->game);
			for (auto& p : allPlayer)
			{
				auto wplayer = p.second.lock();
				if (wplayer && wplayer->el.name == stateName)
				{
					wtarget = wplayer;
					bFound = true;
					break;
				}
			}
			//ڵͼʵѰ
			if (!bFound)
			{
				for (auto& e : eLayer->Ls)
				{
					if (e->el.eventName == stateName)
					{
						wtarget = e;
						break;
					}
				}
			}
		}
		if (wtarget)
		{
			auto we = std::make_shared<CS_MagicBubble>(wtarget);
			we->x = x + (lr == 1 ? 1 : -1) * 12;
			we->y = y - 40;
			gameFunc->SetEntity(shared_from_this(), we);
		}
	}
	else
	{
		if (stateName == L"normal")
			SetState(0, lr);
		else if (stateName == L"walk")
			SetState(1, lr);
		else if (stateName == L"back")
			SetState(2, lr);
		else if (stateName == L"show_wand")
		{
			ani.hideLayerList.erase(0);
			ani.hideLayerList.erase(2);
		}
		else if (stateName == L"magic")
			SetState(3, lr);
		else if (stateName == L"flash")
			SetState(4, lr);
		else if (stateName == L"set_target")
			bSetTarget = true;
	}
}

std::shared_ptr<Entity> CreateCS_ProfessorBoosterAni()
{
	return std::make_shared<CS_ProfessorBoosterAni>();
}
