#include "CS_PottedPlant_Cactus.h"

CS_PottedPlant_Cactus::CS_PottedPlant_Cactus()
{
	ani.png = L"CS_CaveStoryMod";
	drawBeforeOtherEntity = true;
}

void CS_PottedPlant_Cactus::Step()
{
	//գ
	if (Random(0, 120) == 10)
	{
		wink_counter = 8;
	}
	if (wink_counter > 0)
	{
		wink_counter--;
		ani.image_index = 1;
	}
	else
	{
		ani.image_index = 0;
	}
	ani.sprite_index = lr == 0 ? L"ls_pottedplant_cactus_stand_l" : L"ls_pottedplant_cactus_stand_r";
	//ҿʱ
	if (gameFunc->GetPlayerDistance)
	{
		auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
		if (wplayer)
		{
			if (abs(wplayer->x - x) <= 32 && abs(wplayer->y - y) <= 32)
				ani.sprite_index = lr == 0 ? L"ls_pottedplant_cactus_a_l" : L"ls_pottedplant_cactus_a_r";
		}
	}
}

void CS_PottedPlant_Cactus::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_pottedplant_cactus_stand_l" : L"ls_pottedplant_cactus_stand_r";
}

std::shared_ptr<Entity> CreateCS_PottedPlant_Cactus()
{
	return std::make_shared<CS_PottedPlant_Cactus>();
}
