#include "CS_PeWaterDrop.h"

CS_PeWaterDrop::CS_PeWaterDrop()
{
	type = 3;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"pe_water_particles";
	drawBeforeOtherEntity = true;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ʵ
	cbRect.top = cbRect.bottom = cbRect.left = cbRect.right = 1;
}

void CS_PeWaterDrop::Step()
{
	auto& ani_no = ani.image_index;
	vy += 0x20 / ts;
	ani_no = Random(0, 4);
	if (vy > 0x5FF / ts)
		vy = 0x5FF / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	if (++act_wait > 10)
	{
		if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbBottom || cbRect.inWater)
			Destroy();
	}
}

void SetCS_PeWaterDrop(std::shared_ptr<Entity> parent, std::shared_ptr<Entity> target)
{
	for (int i = 0; i < 8; i++)
	{
		auto pe = std::make_shared<CS_PeWaterDrop>();
		pe->x = target->x + Random(-8, 8);
		pe->y = target->y;
		pe->vx = Random(-0x200, 0x200) / ts;
		pe->vy = Random(-0x200, 0x80) / ts - target->vy / 2;
		parent->gameFunc->SetEntity(parent, pe);
	}
	parent->gameFunc->PlaySound(L"CS_056_splash");
}
