#include "CS_PeSweat.h"

CS_PeSweat::CS_PeSweat(std::shared_ptr<Entity> parent)
{
	type = 3;
	attackParent = parent;
	ani.sprite_index = L"pe_sweat_l";
	lr = parent->lr;
	int dx = lr == 0 ? 4 : -4;
	int dy = -4;
	x = parent->x + dx;
	last_x = parent->last_x + dx;
	y = parent->y + dy;
	last_y = parent->last_y + dy;
}

void CS_PeSweat::Step()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
	{
		Destroy();
		return;
	}

	if(ani.png.length() == 0)
		ani.png = L"CS_CaveStoryMod";
	lr = wattackParent->lr;
	int dx = lr == 0 ? 4 : -4;
	int dy = -4;
	x = wattackParent->x + dx;
	last_x = wattackParent->last_x + dx;
	y = wattackParent->y + dy;
	last_y = wattackParent->last_y + dy;
	ani.sprite_index = lr == 0 ? L"pe_sweat_l" : L"pe_sweat_r";
	if (ani.image_index == 2)
		Destroy();
}

void SetCS_PeSweat(std::shared_ptr<Entity> parent)
{
	auto pe = std::make_shared<CS_PeSweat>(parent);
	parent->gameFunc->SetEntity(parent, pe);
}
