#include "CS_MyFishAi.h"

CS_MyFishAi::CS_MyFishAi()
{
	
}

void CS_MyFishAi::Init(std::weak_ptr<Entity> self)
{
	InitControlTarget();
	auto wicon = std::make_shared<CS_MyCharAi_Icon>();
	icon = wicon;
	wicon->color = RGBA(0xff, 0xff, 0xff, 0x80);
	gameFunc->SetEntity(shared_from_this(), wicon);
	Entity::Init(self);
}

void CS_MyFishAi::Step()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
	{
		Destroy();
		return;
	}
	//ղ
	wattackParent->input.key &= GameInput::keybit_switchMc;
	//Ŀͷ
	x = wattackParent->x;
	y = wattackParent->y - 16;
	last_x = wattackParent->last_x;
	last_y = wattackParent->last_y - 16;
	//aiͼ
	auto wicon = icon.lock();
	if (wicon)
	{
		wicon->x = wattackParent->x + wicon->dx;
		wicon->y = wattackParent->y - 16 + wicon->dy;
		wicon->last_x = wattackParent->last_x + wicon->dx;
		wicon->last_y = wattackParent->last_y - 16 + wicon->dy;
		//ͼ
		if (gameFunc->ScriptIsRunning)
		{
			if (gameFunc->ScriptIsRunning(gameFunc->gameScript))
				wicon->ani.sprite_index.clear();
			else
				wicon->ani.sprite_index = L"ai";
		}
		//
		if (wattackParent->hide)
		{
			wicon->ani.sprite_index.clear();
		}
		//12Ҳͼ
		if(gameFunc->GetPlayerIndex(gameFunc->game, wattackParent) == -1)
			wicon->ani.sprite_index.clear();
	}
	Control();
	//okcancel
	wattackParent->input.key &= ~GameInput::keybit_ok;
	wattackParent->input.key &= ~GameInput::keybit_cancel;
}

void CS_MyFishAi::Destroy()
{
	//ҵԼĿĿ꣬ȻƳ
	auto wattackParent = attackParent.lock();
	if (wattackParent)
		wattackParent->ai.reset();
	auto wicon = icon.lock();
	if (wicon)
		wicon->Destroy();
	Entity::Destroy();
}

void CS_MyFishAi::Control()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return;
	auto mychar = std::static_pointer_cast<MyCharEntity> (wattackParent);
	bool bPickUp = false;
	/*-----------------------------ƶ-------------------------------*/
	std::weak_ptr<Entity> followTarget;
	//Ŀ
	if (!mychar->attackParent.expired())
		followTarget = mychar->attackParent;
	//ûûиĿ꣬
	if (followTarget.expired())
		followTarget = gameFunc->GetMyChar_Player1(gameFunc->entityRes);
	auto wfollowTarget = followTarget.lock();
	if (wfollowTarget)
	{
		mychar->attackParent = wfollowTarget;
		//
		mychar->input.SetAtk(wfollowTarget->input.GetAtk());
		float ySearch = 16;
		if (bPickUp)
			ySearch = 4;
		float xSearch = 24;
		if (bPickUp)
			xSearch = 4;
		if (abs(mychar->x - wfollowTarget->x) > xSearch ||
			abs(mychar->y - wfollowTarget->y) > ySearch)
		{
			//Ѱ·ӽĿ
			float dirX = 0, dirY = 0;
			Pathfinding(wfollowTarget->x, wfollowTarget->y, &dirX, &dirY);
			//ֱߵķʽӽĿ
			if (jumpInterval == 0 && dirY < 0)
			{
				jumpInterval = 1;
				//Ծ
				mychar->input.SetJump(true);
			}
			else if (jumpInterval > 0)
			{
				jumpInterval--;
			}
			if (dirX > 0.1f)
			{
				mychar->input.SetRight(true);
			}
			else if (dirX < -0.1f)
			{
				mychar->input.SetLeft(true);
			}
		}
	}
}

void CS_MyFishAi::InitControlTarget()
{
	//Ѱҿƶ
	if (gameFunc->GetGlobalEntityTable)
	{
		auto& allPlayer = *gameFunc->GetGlobalEntityTable(gameFunc->game);
		for (auto& p : allPlayer)
		{
			auto we = p.second.lock();
			if (we)
			{
				auto wplayer = std::dynamic_pointer_cast<MyCharEntity>(we);
				if (wplayer)
				{
					if (wplayer->ai.expired())
						continue;
					if (wplayer->ai.lock() == shared_from_this())
					{
						attackParent = wplayer;
						//Ŀ
						if (wplayer->lastAI_followTarget.length())
						{
							for (auto& t : allPlayer)
							{
								auto wtarget = t.second.lock();
								if (wtarget)
								{
									if (wplayer->lastAI_followTarget == wtarget->globalEntityID)
									{
										wplayer->attackParent = wtarget;
										break;
									}
								}
							}
						}
						break;
					}
				}
			}
		}
	}
	if (attackParent.expired())
		Destroy();
}

bool CS_MyFishAi::AttackAround()
{
	return false;
}

std::shared_ptr<Entity> CreateCS_MyFishAi()
{
	return std::make_shared<CS_MyFishAi>();
}
