#include "CS_MovingPlatform_UD.h"
#include "CS_PeSmoke.h"
CS_MovingPlatform_UD::CS_MovingPlatform_UD()
{
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.enableMovePlatform = true;
	cbRect.left = 16;
	cbRect.top = 16;
	cbRect.right = 16;
	cbRect.bottom = 16;
}

void CS_MovingPlatform_UD::Step()
{
	switch (act_no)
	{
	case 10:
		if (gameFunc->GetGlobalEntityTable)
		{
			auto& allPlayer = *gameFunc->GetGlobalEntityTable(gameFunc->game);
			for (auto& p : allPlayer)
			{
				auto wplayer = p.second.lock();
				if (wplayer)
				{
					if (wplayer->el.name == L"null")
						continue;
					if (wplayer->hide)
						continue;
					if (wplayer)
					{
						if (wplayer->y < y + 0x3200 / ts &&
							wplayer->y > y - 0x64000 / ts &&
							wplayer->x < x + 0x3200 / ts &&
							wplayer->x > x - 0x3200 / ts)
						{
							act_no = 11;
							act_wait = 0;
						}
					}
				}
			}
		}
		break;
	case 11:
		if (++act_wait % 10 == 6)
			gameFunc->PlaySound(L"CS_107_block_move");

		if (cbRect.cbTop)
		{
			vy = 0;
			direct = 2;
			act_no = 20;
			if (gameFunc->SetQuake)
				gameFunc->SetQuake(gameFunc->game, 10, 0);
			gameFunc->PlaySound(L"CS_026_quake");
			for (int i = 0; i < 4; ++i)
			{
				auto pe = std::make_shared<CS_PeSmoke>();
				pe->x = x + Random(-12, 12);
				pe->y = y - 0x2000 / ts;
				pe->vx = Random(-0x600, 0) / ts;
				pe->vy = Random(-341, 341) / ts;
				gameFunc->SetEntity(shared_from_this(), pe);
			}
		}
		else
		{
			vy -= 0x20 / ts;
		}
		break;
	case 20:
		if (gameFunc->GetGlobalEntityTable)
		{
			auto& allPlayer = *gameFunc->GetGlobalEntityTable(gameFunc->game);
			for (auto& p : allPlayer)
			{
				auto wplayer = p.second.lock();
				if (wplayer)
				{
					if (wplayer->el.name == L"null")
						continue;
					if (wplayer->hide)
						continue;
					if (wplayer)
					{
						if (wplayer->y > y - 0x3200 / ts &&
							wplayer->y < y + 0x64000 / ts &&
							wplayer->x < x + 0x3200 / ts &&
							wplayer->x > x - 0x3200 / ts)
						{
							act_no = 21;
							act_wait = 0;
						}
					}
				}
			}
		}
		break;
	case 21:
		if (++act_wait % 10 == 6)
			gameFunc->PlaySound(L"CS_107_block_move");
		if (cbRect.cbBottom)
		{
			vy = 0;
			direct = 0;
			act_no = 10;
			if (gameFunc->SetQuake)
				gameFunc->SetQuake(gameFunc->game, 10, 0);
			gameFunc->PlaySound(L"CS_026_quake");
			for (int i = 0; i < 4; ++i)
			{
				auto pe = std::make_shared<CS_PeSmoke>();
				pe->x = x + Random(-12, 12);
				pe->y = y + 0x2000 / ts;
				pe->vx = Random(-0x600, 0) / ts;
				pe->vy = Random(-341, 341) / ts;
				gameFunc->SetEntity(shared_from_this(), pe);
			}
		}
		else
		{
			vy += 0x20 / ts;
		}
		break;
	}
	if (vy > 0x200 / ts)
		vy = 0x200 / ts;
	if (vy < -0x200 / ts)
		vy = -0x200 / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_MovingPlatform_UD::SetState(int stateID, int lr)
{
	if (stateID < 200)
	{
		this->lr = lr;
		switch (stateID)
		{
		case 0:
			x += 0x1000 / ts;
			y += 0x1000 / ts;
			direct = lr == 0 ? 0 : 2;
			if (direct == 0)
				act_no = 10;
			else
				act_no = 20;
			vx = 0;
			vy = 0;
			ani.sprite_index = el.arg;
			break;
		}
	}
}

std::shared_ptr<Entity> CreateCS_MovingPlatform_UD()
{
	return std::make_shared<CS_MovingPlatform_UD>();
}
