#include "CS_MonsterXEye.h"

void CS_MonsterXEye::Init(std::weak_ptr<Entity> self)
{
	srcX = x;
	srcY = y;
	Entity::Init(self);
}

void CS_MonsterXEye::Step()
{
	switch (stateID)
	{
	case 0:
		vx = vy = 0;
		break;
	case 1:
		vy = 0x100 / ts;
		break;
	case 2:
		vy = -0x100 / ts;
		break;
	}
	//ִ˶
	Entity::Step();
}

void  CS_MonsterXEye::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.image_index = stateID;
	ani.sprite_index = lr == 0 ? L"ls_monsterx_eye_l" : L"ls_monsterx_eye_r";
}

void CS_MonsterXEye::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"down")
		stateID = 1;
	else if (stateName == L"up")
		stateID = 2;
	else if (stateName == L"stop")
		stateID = 0;
	else if (stateName == L"hide")
		ani.png = L"";
	else if (stateName == L"show")
		ani.png = L"CS_CaveStoryMod";
	else if (stateName == L"reset_pos")
	{
		x = srcX;
		y = srcY;
	}
}

std::shared_ptr<Entity> CreateCS_MonsterXEye()
{
	return std::make_shared<CS_MonsterXEye>();
}
