#include "CS_MagicBubble.h"

CS_MagicBubble::CS_MagicBubble(std::shared_ptr<Entity> target)
{
	this->target = target;
	lr = x > target->x ? 0 : 1;
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_magic_bubble";
	action_timecounter = 30;
}

void CS_MagicBubble::Step()
{
	if (action_timecounter > 0)
	{
		action_timecounter--;
		return;
	}
	const float speed = 0x800 / ts;
	auto wtarget = target.lock();
	if (wtarget)
	{
		if (abs(x - wtarget->x) <= 4 && abs(y - wtarget->y) <= 4)
		{
			//Ŀ
			wtarget->SetState(L"transform_fish", 300);
			Destroy();
		}
		else
		{
			//׷
			float vec_x = wtarget->x - x;
			float vec_y = wtarget->y - y;
			auto vec = XMVector2Normalize(XMVectorSet(vec_x, vec_y, 0, 0));
			float dir_vx = XMVectorGetX(vec);
			float dir_vy = XMVectorGetY(vec);
			vx = dir_vx * speed;
			vy = dir_vy * speed;
		}
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}
