#include "CS_KingSwordV3BladeEdge.h"
#include "CS_PeGunShotHit.h"
#include "CS_PeHurt.h"

CS_KingSwordV3BladeEdge::CS_KingSwordV3BladeEdge(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	//ײ
	cbRect.enableCbRect = true;
	//ײ
	cbRect.left = 16;
	cbRect.right = 16;
	cbRect.top = 16;
	cbRect.bottom = 16;
	ani.png = L"CS_CaveStoryMod";
	//
	damaged_limit = 100;
	damage_reset_counter = 2;
}

void CS_KingSwordV3BladeEdge::Step()
{
	//ִ˶
	Entity::Step();
	if (ani.image_index == 5)
		Destroy();
}

void CS_KingSwordV3BladeEdge::SetState(int stateID, int lr)
{
	x += lr == 0 ? 0x200 / ts : -0x200 / ts;
	y -= 0x1800 / ts;
	vx = lr == 0 ? -0x400 / ts : 0x400 / ts;
	vy = 0x400 / ts;
	last_x = x;
	last_y = y;
	ani.sprite_index = lr == 0 ? L"am_sword3_edge_l" : L"am_sword3_edge_r";
}

void CS_KingSwordV3BladeEdge::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = ani.image_index == 1 ? 2 : 1;
	if (lr == 0)
	{
		*outAngle = 270;
	}
	else
	{
		*outAngle = 270;
	}
	*outTakedown = false;
	*outElemType = 0;
	*outShockForce = 0 / ts;
	*outHeavy = 0;
}

void CS_KingSwordV3BladeEdge::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	if (realDamage == 0)
	{
		gameFunc->PlaySound(L"CS_031_shot_bounce");
		SetCS_PeGunShotHit(shared_from_this(), centerX, centerY);
	}
	else
	{
		auto wtarget = target.lock();
		if (wtarget)
		{
			if (wtarget->hp > 0)
				SetCS_PeHurt_Num3(shared_from_this(), centerX, centerY);
		}
	}
}
