#include "CS_KingHurt.h"
const int CS_KingSTATENAME_HURT = GetNextEntityStateID();
CS_KingHurt::CS_KingHurt()
{
	stateID = CS_KingSTATENAME_HURT;
}

void CS_KingHurt::State()
{
	auto we = e.lock();
	if (!we)
		return;

	we->ani.sprite_index = we->lr == 0 ? L"mc_king_hurt_l" : L"mc_king_hurt_r";
}

void CS_KingHurt::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
	{
		auto we = e.lock();
		if (!we)
			return;

		auto mychar = std::static_pointer_cast<MyCharEntity>(we);
		enable = true;
		mychar->action_timecounter = 30;
	}
	else
		enable = false;
}
