#pragma once
#include "Entity.h"
#include "EntityState.h"
#include "EntityStateFlashEffect.h"
#include "EntityStateInvincible.h"
#include "CS_QuoteGravity.h"
#include "CS_KingWater.h"
#include "CS_KingDrown.h"
#include "CS_KingControl.h"
#include "CS_KingResist.h"
#include "CS_KingJump.h"
#include "CS_KingStand.h"
#include "CS_KingMove.h"
#include "CS_KingAir.h"
#include "CS_KingFaceToBack.h"
#include "CS_KingClimb.h"
#include "CS_KingHurt.h"
#include "CS_KingSwordV1.h"
#include "CS_KingSwordV2.h"
#include "CS_KingSwordV3.h"
#include "CS_KingGuard.h"
#include "CS_KingLifeUp.h"
#define CS_KING_CREATENAME L"CS_mychar_king"
//ҽɫ 
class CS_King :
    public MyCharEntity
{
public:
    CS_King();
	void Init(std::weak_ptr<Entity> self) override;
	void Step() override;
	void SetState(int stateID, int lr) override;
	void SetState(std::wstring stateName, int lr) override;
	void LoadSaveData() override;//ر
	void WriteSaveData() override;//д뱣
	bool Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage) override;
	void Gain(std::weak_ptr<Entity> item) override;
	void Destroy() override;
	void GetIcon(std::wstring& png, std::wstring& sprite_index, int& image_index, std::set<int>& hideLayerList) override;
	void CrushDeath();
	void CopyFrom(std::shared_ptr<Entity>& another) override;//ԼһԼͬʵһģһ
	void GetAnimateOffset(float& outDx, float& outDy) override;//ȡƫ
	//ͼʾ
	float animation_moveSpeed = 0x200 / ts;
	bool animation_delay = false;//·ӳһ֡뵽
	//״̬ģ
	EntityStateFlashEffect stateFlash;
	EntityStateInvincible stateInvincible;
	CS_QuoteGravity stateGravity;
	CS_KingWater stateWater;
	CS_KingDrown stateDrown;
	CS_KingControl stateControl;
	CS_KingResist stateResist;
	CS_KingJump stateJump;
	CS_KingStand stateStand;
	CS_KingMove stateMove;
	CS_KingAir stateAir;
	CS_KingFaceToBack stateFaceToBack;
	CS_KingClimb stateClimb;
	CS_KingHurt stateHurt;
	//ģ
	CS_KingSwordV1 skillSwordV1;
	CS_KingSwordV2 skillSwordV2;
	CS_KingSwordV3 skillSwordV3;
	CS_KingGuard skillGuard;
	CS_KingLifeUp skillLifeUp;
	//
	std::wstring crushEvent;
	std::list<std::weak_ptr<Entity>> amList;
};

std::shared_ptr<Entity> CreateCS_King();