#include "CS_KanpaJump.h"
#include "CS_Kanpa.h"
const int CS_KanpaSTATENAME_JUMP = GetNextEntityStateID();
CS_KanpaJump::CS_KanpaJump()
{
	enable = true;
	SetPhysice(false);
	jump_disable = true;
	jumped = true;
	stateID = CS_KanpaSTATENAME_JUMP;
}

void CS_KanpaJump::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Kanpa>(we);
	if (mychar->moveMode == 0)
	{
		ground_jump = 0x500 / ts;
	}
	else
	{
		ground_jump = 0x560 / ts;
	}
	inwater_jump = ground_jump / 2;
}

void CS_KanpaJump::State()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Kanpa>(we);
	//״̬
	if (we->cbRect.cbBottom)
		jumped = false;
	//
	if (!we->input.GetJump())
		jump_disable = false;
	//ͨԾ
	bool a1 = we->cbRect.cbBottom &&
		!mychar->InAction() &&
		!jumped;
	bool b1 = we->input.GetJump() &&
		!we->blockJump &&
		!jump_disable;

	bool a = a1;
	bool b = b1;
	if (a && b)
	{
		if (a1)
		{
			we->vy = -jump;
		}
		jumped = true;
		jump_disable = true;
		we->gameFunc->PlaySound(L"jumpNormal");
		//Ƿڿ
		mychar->ChangeState(mychar->stateAir.GetStateID());
		mychar->action_timecounter = 0;
	}
}

void CS_KanpaJump::SetPhysice(bool bInWater)
{
	if (bInWater)
		jump = inwater_jump;
	else
		jump = ground_jump;
}

void CS_KanpaJump::SetJump()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Kanpa>(we);
	we->vy = -jump;
	jumped = true;
	jump_disable = true;
	we->gameFunc->PlaySound(L"jumpNormal");
}

