#include "CS_HiddenItem.h"
#include "CS_PeSmoke.h"
#include "CS_Heart.h"
CS_HiddenItem::CS_HiddenItem()
{
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 6;
	hp_max = hp = 10;
}

bool CS_HiddenItem::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_104");
	}
	else
	{
		gameFunc->PlaySound(L"CS_070_expl_small");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//
		SetHeartSmallStatic(shared_from_this(), x, y);
		Destroy();
	}
	return true;
}

std::shared_ptr<Entity> CreateCS_HiddenItem()
{
	return std::make_shared<CS_HiddenItem>();
}
