#include "CS_FishHook.h"
#include "CS_PeWaterDrop.h"

CS_FishHook::CS_FishHook()
{
	//ʼ
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"am_fishhook_90";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.fullWaterBlock = true;
	//ײ
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 4;
}

void CS_FishHook::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	Entity::Init(self);
}

void CS_FishHook::Step()
{
	input.key = 0;
	switch (stateID)
	{
	case 0:
		break;
	case 1://ƶڵ¼
		if(gameFunc->GetCheckEventPlayer)
		{
			auto wplayer = gameFunc->GetCheckEventPlayer(gameFunc->game).lock();
			if (wplayer)
			{
				if (abs(x - wplayer->x) <= 2 && abs(y - wplayer->y) <= 2)
				{
					stateID = 0;
					vx = 0;
					vy = 0;
				}
				else
				{
					if (x > wplayer->x)
						input.SetLeft(true);
					else
						input.SetRight(true);
					if (y > wplayer->y)
						input.SetUp(true);
					else
						input.SetDown(true);
				}
			}
		}
		else
		{
			stateID = 0;
		}
		break;
	}
	
	if (cbRect.inWater)
	{
		Move();
	}
	else
	{
		setWaterSplash = true;
		//ڵֻܵ
		stateGravity.Step();
	}
	//ˮˮ
	if (setWaterSplash && cbRect.inWater)
	{
		setWaterSplash = false;
		//ˮ
		SetCS_PeWaterDrop(shared_from_this(), shared_from_this());
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_FishHook::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	switch (stateID)
	{
	case 0:
		break;
	case 1://ƶڵ¼
		break;
	}
}

void CS_FishHook::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"move_to_check_event_player")
		SetState(1, lr);
}

void CS_FishHook::Move()
{
	bool apply_resistH = true;
	bool apply_resistV = true;
	bool opUp = false;
	bool opDown = false;
	bool opLeft = false;
	bool opRight = false;
	//ƶ
	//
	if (input.GetUp() || axis[0] < 0)
	{
		apply_resistV = false;
		ud = -1;
		//Ƿֱ
		float joyMax_move;
		if (axis[0] < 0)
		{
			joyMax_move = max_move * -axis[0];
			//ı䶯ٶ
			ani.image_counter_speed = -axis[0];
		}
		else
		{
			joyMax_move = max_move;
			ani.image_counter_speed = 1;
		}
		if (vy > -joyMax_move)
		{
			if (vy - move > -joyMax_move)
				vy -= move;
			else
				vy = -joyMax_move;
		}
		opUp = true;
	}
	//
	else if (input.GetDown() || axis[1] > 0)
	{
		apply_resistV = false;
		ud = 1;
		//Ƿֱ
		float joyMax_move;
		if (axis[1] > 0)
		{
			joyMax_move = max_move * axis[1];
			//ı䶯ٶ
			ani.image_counter_speed = axis[1];
		}
		else
		{
			joyMax_move = max_move;
			ani.image_counter_speed = 1;
		}
		if (vy < joyMax_move)
		{
			if (vy + move < joyMax_move)
				vy += move;
			else
				vy = joyMax_move;
		}
		opDown = true;
	}
	else
	{
		ud = 0;
	}
	//
	if (input.GetLeft() || axis[2] < 0)
	{
		apply_resistH = false;
		lr = 0;
		//Ƿֱ
		float joyMax_move;
		if (axis[2] < 0)
		{
			joyMax_move = max_move * -axis[2];
			//ı䶯ٶ
			ani.image_counter_speed = -axis[2];
		}
		else
		{
			joyMax_move = max_move;
			ani.image_counter_speed = 1;
		}
		if (vx > -joyMax_move)
		{
			if (cbRect.cbLeft)
				vx = -joyMax_move / 2;
			else
			{
				if (vx - move > -joyMax_move)
					vx -= move;
				else
					vx = -joyMax_move;
			}
		}
		opLeft = true;
	}
	//
	else if (input.GetRight() || axis[3] > 0)
	{
		apply_resistH = false;
		lr = 1;
		//Ƿֱ
		float joyMax_move;
		if (axis[3] > 0)
		{
			joyMax_move = max_move * axis[3];
			//ı䶯ٶ
			ani.image_counter_speed = axis[3];
		}
		else
		{
			joyMax_move = max_move;
			ani.image_counter_speed = 1;
		}
		if (vx < joyMax_move)
		{
			if (cbRect.cbRight)
				vx = joyMax_move / 2;
			else
			{
				if (vx + move < joyMax_move)
					vx += move;
				else
					vx = joyMax_move;
			}
		}
		opRight = true;
	}
	//
	if (apply_resistH)
		vx /= 1.1f;
	if (apply_resistV)
		vy /= 1.1f;

	if (opLeft && opUp)
		ani.sprite_index = L"am_fishhook_225";
	else if (opRight && opUp)
		ani.sprite_index = L"am_fishhook_315";
	else if (opLeft && opDown)
		ani.sprite_index = L"am_fishhook_135";
	else if (opRight && opDown)
		ani.sprite_index = L"am_fishhook_45";
	else if (opLeft)
		ani.sprite_index = L"am_fishhook_180";
	else if (opRight)
		ani.sprite_index = L"am_fishhook_0";
	else if (opUp)
		ani.sprite_index = L"am_fishhook_270";
	else if (opDown)
		ani.sprite_index = L"am_fishhook_90";
}

std::shared_ptr<Entity> CreateCS_FishHook()
{
	return std::make_shared<CS_FishHook>();
}
