#include "CS_Enemy_Skullhead.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_AmSkeletonProjectile.h"
#include "CS_Enemy_Crow_SkullheadCatcher.h"
CS_Enemy_Skullhead::CS_Enemy_Skullhead()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 14;
	cbRect.top = 8;
	cbRect.bottom = 4;
	hp_max = hp = 20;
	dropExp = 10;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	el.name = CS_ENEMY_SKULLHEAD_CREATENAME;
}

void CS_Enemy_Skullhead::Init(std::weak_ptr<Entity> self)
{
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_Skullhead::Step()
{
	auto& ani_no = ani.image_index;
	auto wcrow = pCrow.lock();
	stateSplash.Step();
	if (act_no >= 10 && pCrow.expired())
	{
		pCrow.reset();
		act_no = 3;
		vx = 0;
		vy = 0;
		count2 = 1;
	}
	if (wcrow && act_no != 10 && act_no != 11)
		act_no = 10;
	if (cbRect.cbLeft)
	{
		lr = 1;
		vx = 0x100 / ts;
	}
	if (cbRect.cbRight)
	{
		lr = 0;
		vx = -0x100 / ts;
	}
	switch (act_no)
	{
	case 0:
		if (wcrow)
			act_no = 10;
		else
			act_no = 1;
		[[fallthrough]];
	case 1:
		if (++act_wait > 3)
		{
			vy = -0x400 / ts;
			act_no = 3;
			ani_no = 1;

			if (count2)
			{
				if (lr == 0)
					vx = -0x200 / ts;
				else
					vx = 0x200 / ts;
			}
			else
			{
				if (lr == 0)
					vx = -0x100 / ts;
				else
					vx = 0x100 / ts;
			}
		}
		ani_no = 0;
		break;
	case 3:
		if (cbRect.cbBottom)
		{
			act_no = 1;
			act_wait = 0;
			vx = 0;
		}
		if (cbRect.cbBottom || vy > 0)
			ani_no = 0;
		else
			ani_no = 1;
		break;
	case 10:
		if (count1 < 50)
		{
			++count1;
		}
		else
		{
			if (gameFunc->GetPlayerDistanceWithLineTest)
			{
				auto wplayer = gameFunc->GetPlayerDistanceWithLineTest(gameFunc->game, x, y).lock();
				if (wplayer)
				{
					if (x - 128 * 2 < wplayer->x && x + 128 * 2 > wplayer->x &&
						y - 96 * 2 < wplayer->y && y + 96 * 2 > wplayer->y)
					{
						act_no = 11;
						act_wait = 0;
						ani_no = 1;
					}
				}
			}
		}
		break;
	case 11:
		if (++act_wait == 30 || act_wait == 35)
		{
			if (gameFunc->GetPlayerDistanceWithLineTest)
			{
				auto wplayer = gameFunc->GetPlayerDistanceWithLineTest(gameFunc->game, x, y).lock();
				if (wplayer)
				{
					XMVECTOR vec = XMVector2Normalize(XMVectorSet(wplayer->x - x, wplayer->y - y, 0, 0));
					SetCS_AmSkeletonProjectile(shared_from_this(), x, y, 2 * XMVectorGetX(vec), 2 * XMVectorGetY(vec));
					gameFunc->PlaySound(L"CS_039_em_fire");
				}
				else
				{
					if (act_wait > 0)
						act_wait--;
				}
			}
		}
		if (act_wait > 50)
		{
			count1 = 0;
			act_no = 10;
			ani_no = 0;
		}
		break;
	}
	vy += 0x40 / ts;
	if (vy > 0x5FF / ts)
		vy = 0x5FF / ts;
	//һײ
	Entity::ClearCollisionResult();
	if (wcrow && act_no >= 10)
	{
		x = wcrow->x;
		last_x = wcrow->last_x;
		y = wcrow->y + 0x2000 / ts;
		last_y = wcrow->last_y + 0x2000 / ts;
		lr = wcrow->lr;
		wcrow->count1 = 0;
	}
	else
	{
		//ִ˶
		Entity::Step();
	}
	//ִײ
	Entity::Collision();
	ani.sprite_index = lr == 0 ? L"ls_skullhead_l" : L"ls_skullhead_r";
}

void CS_Enemy_Skullhead::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_skullhead_l" : L"ls_skullhead_r";
}

void CS_Enemy_Skullhead::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 8;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Skullhead::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_052_enemy_hurt_big");
	}
	else
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::weak_ptr<Entity> CS_Enemy_Skullhead::BeginCaught(std::weak_ptr<Entity> e)
{
	auto wcrow = pCrow.lock();
	if (wcrow)
		return wcrow;
	return shared_from_this();
}

void CS_Enemy_Skullhead::EndCaught(std::weak_ptr<Entity> e)
{
}

std::shared_ptr<Entity> CreateCS_Enemy_Skullhead()
{
	return std::make_shared<CS_Enemy_Skullhead>();
}
