#include "CS_Enemy_Sandcroc.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
CS_Enemy_Sandcroc::CS_Enemy_Sandcroc()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	isTrap = true;//״̬
	hp_max = hp = 30;
	dropExp = 9;
	//damage_reset_counter = 60;Լõ
	//attackState_reset_counter_max = 60;
	cbRect.left = cbRect.right = 7;
	cbRect.top = 24;
	cbRect.bottom = 8;
}

void CS_Enemy_Sandcroc::Step()
{
	auto& ani_no = ani.image_index;
	//ִ˶
	Entity::Step();
	switch (act_no)
	{
	case 0:
		ani_no = 0;
		act_no = 1;
		act_wait = 0;
		tgt_y = y;
	/*	bits &= ~NPC_SHOOTABLE;
		bits &= ~NPC_INVULNERABLE;
		bits &= ~NPC_SOLID_SOFT;
		bits &= ~NPC_IGNORE_SOLIDITY;*/
		hideOnGround = true;
		isTrap = true;
		cbRect.enableSoild = true;
		cbRect.enableSelfSoild = false;
		[[fallthrough]];
	case 1:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (wplayer->x > x - 8 && wplayer->x < x + 8 && 
					wplayer->y > y - 8 && wplayer->y < y)
				{
					act_no = 2;
					act_wait = 0;
					gameFunc->PlaySound(L"CS_102_jaws");
				}
				if (x < wplayer->x)
					x += 2;
				if (x > wplayer->x)
					x -= 2;
			}
		}
		break;
	case 2:
		if (++ani_wait > 3)
		{
			++ani_no;
			ani_wait = 0;
		}
		if (ani_no == 3)
		{
			damage = 10;
			attackState = true;
			damaged.clear();
		}
		if (ani_no == 4)
		{
			//bits |= NPC_SHOOTABLE;
			hideOnGround = false;
			isTrap = false;
			act_no = 3;
			act_wait = 0;
		}
		break;
	case 3:
		//bits |= NPC_SOLID_SOFT;
		cbRect.enableSelfSoild = true;
		damage = 0;
		++act_wait;
		if (shock_counter > 0)
		{
			act_no = 4;
			act_wait = 0;
		}
		break;
	case 4:
		//bits |= NPC_IGNORE_SOLIDITY;
		cbRect.enableSoild = false;
		y++;
		if (++act_wait == 32)
		{
			//bits &= ~NPC_SOLID_SOFT;
			//bits &= ~NPC_SHOOTABLE;
			hideOnGround = true;
			isTrap = true;
			act_no = 5;
			act_wait = 0;
		}
		break;
	case 5:
		if (act_wait < 100)
		{
			++act_wait;
		}
		else
		{
			y = tgt_y;
			ani_no = 0;
			act_no = 0;
		}
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִײ
	Entity::Collision();
	ani.sprite_index = lr == 0 ? L"ls_sandcroc_l" : L"ls_sandcroc_r";
}

void CS_Enemy_Sandcroc::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_sandcroc_l" : L"ls_sandcroc_r";
}

void CS_Enemy_Sandcroc::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = damage;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Sandcroc::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (hideOnGround && getDamage <= 1000)
		return false;
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_052_enemy_hurt_big");
	}
	else
	{
		gameFunc->PlaySound(L"CS_072_big_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_Sandcroc()
{
	return std::make_shared<CS_Enemy_Sandcroc>();
}
