#include "CS_Enemy_GraveKeeper.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
CS_Enemy_GraveKeeper::CS_Enemy_GraveKeeper()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 6;
	cbRect.top = cbRect.bottom = 5;
	hp_max = hp = 20;
	dropExp = 4;
	cbRect.left = cbRect.right = 4;
	cbRect.top = 12;
	cbRect.bottom = 8;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_GraveKeeper::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_GraveKeeper::Step()
{
	auto& ani_no = ani.image_index;
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateGravity.Step();
	stateResist.Step();
	stateSplash.Step();
	switch (act_no)
	{
	case 0:
		frontDefend = true;
		act_no = 1;
		attackState = false;
		cbRect.left = cbRect.right = 4;
		cbRect.top = 12;
		cbRect.bottom = 8;
		resetAtkState = true;
		[[fallthrough]];
	case 1:
		ani_no = 0;
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (wplayer->x < x)
					lr = 0;
				else
					lr = 1;
				if (x - 0x10000 / ts < wplayer->x && x + 0x10000 / ts > wplayer->x && y - 0x6000 / ts < wplayer->y && y + 0x4000 / ts > wplayer->y)
				{
					ani_wait = 0;
					act_no = 2;
				}
			}
		}
		
		if (shock_counter > 0)
		{
			ani_no = 1;
			ani_wait = 0;
			act_no = 2;
			frontDefend = true;
		}
		break;
	case 2:
		if (++ani_wait > 6)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 3)
			ani_no = 0;
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (x - 0x2000 / ts < wplayer->x && x + 0x2000 / ts > wplayer->x)
				{
					act_wait = 0;
					act_no = 3;
					frontDefend = false;
					if (lr == 0)
						cbRect.left = 0x2400 / ts;
					else
						cbRect.right = 0x2400 / ts;
					gameFunc->PlaySound(L"CS_034_fireball");
					if (lr == 0)
						vx = -0x400 / ts;
					else
						vx = 0x400 / ts;
				}
				if (wplayer->x < x)
				{
					lr = 0;
					vx = -0x100 / ts;
				}
				else
				{
					lr = 1;
					vx = 0x100 / ts;
				}
			}
		}
		break;
	case 3:
		vx = 0;
		if (++act_wait > 40)
		{
			act_wait = 0;
			act_no = 4;
			gameFunc->PlaySound(L"CS_106");
		}
		ani_no = 4;
		break;
	case 4:
		if (resetAtkState)
		{
			resetAtkState = false;
			attackState = true;
		}
		if (++act_wait > 2)
		{
			act_wait = 0;
			act_no = 5;
		}
		ani_no = 5;
		break;
	case 5:
		ani_no = 6;
		if (++act_wait > 60)
			act_no = 0;
		break;
	}
	if (vx > 0x400 / ts)
		vx = 0x400 / ts;
	if (vx < -0x400 / ts)
		vx = -0x400 / ts;
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	{
		float l = cbRect.left;
		float r = cbRect.right;
		float t = cbRect.top;
		float b = cbRect.bottom;
		cbRect.left = cbRect.right = 4;
		cbRect.top = 12;
		cbRect.bottom = 8;
		//ִײ
		Entity::Collision();
		cbRect.left = l;
		cbRect.right = r;
		cbRect.top = t;
		cbRect.bottom = b;
	}
	//άб
	Entity::KeepOnSlopes();
	ani.sprite_index = lr == 0 ? L"ls_gravekeeper_l" : L"ls_gravekeeper_r";
}

void CS_Enemy_GraveKeeper::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_gravekeeper_l" : L"ls_gravekeeper_r";
}

void CS_Enemy_GraveKeeper::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 10;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_GraveKeeper::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	auto wsrc = src.lock();
	if (wsrc)
	{
		if (frontDefend && !wsrc->noDir)
		{
			if (wsrc->speedDir)
			{
				if (lr == 0 && wsrc->vx > 0 ||
					lr == 1 && wsrc->vx < 0)
				{
					*outRealDamage = 0;
					return true;
				}
			}
			else
			{
				if (lr != wsrc->lr)
				{
					*outRealDamage = 0;
					return true;
				}
			}
		}
	}
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_051_enemy_hurt");
	}
	else
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_GraveKeeper()
{
	return std::make_shared<CS_Enemy_GraveKeeper>();
}
