#include "CS_CurlyMachineGun.h"
#include "CS_Curly.h"
#include "CS_PeOutOfAmmo.h"
#include "CS_CurlyMachineGunBlade.h"
const int CS_CurlySTATENAME_MACHINEGUN = GetNextEntityStateID();
CS_CurlyMachineGun::CS_CurlyMachineGun()
{
	stateID = CS_CurlySTATENAME_MACHINEGUN;
	cd_counter = 0;
	cd_counter_max = 7;
	iconIndex = 0;
}

const wchar_t* CS_CurlyMachineGun::GetSaveName()
{
	return L"MachineGun";
}

const wchar_t* CS_CurlyMachineGun::GetFuncName()
{
	return L"CurlySkill_MachineGun";
}

const wchar_t* CS_CurlyMachineGun::GetCheckFuncName()
{
	return L"CurlySkill_MachineGun_Check";
}

void CS_CurlyMachineGun::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Curly>(we);
	bUIShowDisableSkill = !(
		mychar->lastGun != this &&
		!lock
		);
	bool a1 = mychar->lastGun != this &&
		!lock;
	bool b1 = (mychar->input.key & keyMask);
	bool c1 = mychar->mp >= mp_cost;

	bool a = a1;
	bool b = b1;
	bool c = c1;
	if (a && b && c)
	{
		mychar->lastSkill = this;
		mychar->ChangeState(GetStateID());
	}
	//лǹתģ飬ʹøֻǹ
	openGatling = false;
	if (we->gameFunc->PlayerHaveItem)
		if (we->gameFunc->PlayerHaveItem(we->gameFunc->game, L"MachinegunWheelModule"))
			openGatling = true;
	//ȴʱ
	if (cd_counter > 0)
		cd_counter--;
	//ӵ
	fcounter = (float)ammo_count / ammo_count_max;
	//ӵľЧʱ
	if (outOfAmmo_counter > 0)
		outOfAmmo_counter--;
	//ӵָ
	if (!we->input.GetAtk())
	{
		if (shootingToRefill_counter > 0)
			shootingToRefill_counter--;
		if (shootingToRefill_counter == 0)
		{
			ammoRefill_counter_max = 2;
			if (ammoRefill_counter > 0)
				ammoRefill_counter--;
			if (ammoRefill_counter == 0 && ammo_count < ammo_count_max)
			{
				ammo_count++;
				ammoRefill_counter = ammoRefill_counter_max;
			}
		}
	}
	if (ammo_count < ammo_count_max)
	{
		if (ammoBar.expired())
		{
			auto wammoBar = std::make_shared<PeReadyBar>(mychar, &fcounter, RGBA(0xff, 0xff, 0xff, 0xff), 0, -16,
				&CS_CurlyMachineGun::ReadyBar_Leave,
				&CS_CurlyMachineGun::ReadyBar_Destroy);
			ammoBar = wammoBar;
			we->gameFunc->SetEntity(we, wammoBar);
		}
	}
	EntitySkillState::SubStep();
}

void CalculateShotgunAngles(std::vector<float>& angles, int num, float aveAngle, float centerAngle)
{
	angles.clear();

	if (num <= 0)
		return;

	// ɢǶȷΧ
	float totalSpread = aveAngle * (num - 1);

	// ʼǶ(ӵĽǶ)
	float startAngle = centerAngle - totalSpread / 2.0f;

	// ÿӵĽǶ
	for (int i = 0; i < num; ++i)
	{
		float angle = startAngle + i * aveAngle;
		angles.push_back(angle);
	}
}

void CS_CurlyMachineGun::ChangeStateMsg(int stateID)
{
	auto we = e.lock();
	if (!we)
		return;
	auto mychar = std::static_pointer_cast<CS_Curly>(we);

	if (stateID == GetStateID())
	{
		//ʼ
		enable = true;
		//лǹ
		mychar->lastGun = this;
		we->gameFunc->PlaySound(L"CS_004_switchweapon");
	}
	else if (stateID == CS_CurlySTATENAME_FIRE && cd_counter == 0 &&
		mychar->lastGun == this)
	{
		enable = false;
		//ӵ
		if (ammo_count > 0)
		{
			ammo_count--;
			shootingToRefill_counter = shootingToRefill_counter_max;
			//
			if (openGatling)
			{
				int num = 5;
				float aveAngle = 5;
				float centerAngle = 0;
				//ɢ
				if (we->ud == 0)
					centerAngle = we->lr == 0 ? 180.0f : 0.0f;
				else
					centerAngle = we->ud == 1 ? 90.0f : 270.0f;
				centerAngle += Random(-1, 1);
				CalculateShotgunAngles(angleBuffer, num, aveAngle, centerAngle);
				for (int i = 0; i < num; i++)
				{
					auto am = std::make_shared<CS_CurlyMachineGunBlade>(we);
					float speed = 0x1000 / ts;
					speed += Random(-0x300, 0x300) / ts;
					am->vx = speed * cosf(angleBuffer[i] * deg2rad);
					am->vy = speed * sinf(angleBuffer[i] * deg2rad);
					we->gameFunc->SetEntity(we, am);
				}
				//ס
				cd_counter = cd_counter_max;
				//
				if (we->ud == 1)
				{
					if (we->vy > 0)
						we->vy /= 2.0f;
					if (we->vy - 2 > -4)
						we->vy -= 2;
					else
						we->vy = -4;
				}
				else if (we->ud == -1)
				{
					if (we->vy + 1.0f < 4)
						we->vy += 1.0f;
					else
						we->vy = 4;
				}
			}
			else
			{
				auto am = std::make_shared<CS_CurlyMachineGunBlade>(we);
				we->gameFunc->SetEntity(we, am);
				//ס
				cd_counter = cd_counter_max;
				//
				if (we->ud == 1)
				{
					if (we->vy > 0)
						we->vy /= 2.0f;
					if (we->vy - 1 > -2)
						we->vy--;
					else
						we->vy = -2;
				}
				else if (we->ud == -1)
				{
					if (we->vy + 0.5f < 2)
						we->vy += 0.5f;
					else
						we->vy = 2;
				}
			}
		}
		else
		{
			if (outOfAmmo_counter == 0)
			{
				SetCS_PeOutOfAmmo(we, we->x, we->y);
				outOfAmmo_counter = outOfAmmo_counter_max;
				we->gameFunc->PlaySound(L"CS_037_gun_click");
			}
		}
	}
	else
		enable = false;
}

bool CS_CurlyMachineGun::ReadyBar_Leave(std::weak_ptr<Entity> e)
{
	auto we = e.lock();
	if (!we)
		return true;

	auto mychar = std::static_pointer_cast<CS_Curly>(we);
	auto& skillMachineGun = mychar->skillMachineGun;
	bool bLeave = skillMachineGun.ammo_count == skillMachineGun.ammo_count_max;
	if (bLeave)
		skillMachineGun.ammoBar.reset();
	return bLeave;
}

void CS_CurlyMachineGun::ReadyBar_Destroy(std::weak_ptr<Entity> e)
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Curly>(we);
	auto& skillMachineGun = mychar->skillMachineGun;
	skillMachineGun.ammoBar.reset();
}
