#include "CS_Chest.h"

CS_Chest::CS_Chest()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_chest_closed";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	act_no = 1;
	drawBeforeOtherEntity = true;
}

void CS_Chest::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Chest::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateGravity.Step();
	stateResist.Step();
	stateSplash.Step();
	auto& ani_no = ani.image_index;
	if (lr == 0)
	{
		switch (act_no)
		{
		case 1:
			ani_no = 0;
			if (Random(0, 30) == 0)
				act_no = 2;
			break;
		case 2:
			if (++ani_wait > 1)
			{
				ani_wait = 0;
				++ani_no;
			}
			if (ani_no > 2)
			{
				ani_no = 0;
				act_no = 1;
			}
			break;
		}
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_Chest::SetState(int stateID, int lr)
{
	this->lr = lr;
	if (lr == 0)
		ani.sprite_index = L"ls_chest_closed";
	else
		ani.sprite_index = L"ls_chest_open";
}

std::shared_ptr<Entity> CreateCS_Chest()
{
	return std::make_shared<CS_Chest>();
}
