#include "CS_Bar.h"

CS_Bar::CS_Bar()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_bar_close";
	drawBeforeOtherEntity = true;
	cbRect.left = 5;
	cbRect.right = 24;
}

void CS_Bar::Step()
{
	cbRect.enableCbRect = lr == 0;
	cbRect.enableSoild = lr == 0;
	if (lr == 0)
	{
		switch (act_no)
		{
		case 0:
			act_no = 1;
			break;

		case 10:
			act_no = 11;
			act_wait = 0;
			tgt_x = x;
			[[fallthrough]];
		case 11:
			++act_wait;
			x = tgt_x;
			if (act_wait / 3 % 2)
				x ++;
			break;
		case 20:
			act_no = 21;
			act_wait = 0;
			vy = -0x400 / ts;
			vx = 0x100 / ts;
			gameFunc->PlaySound(L"CS_025_funny_explode");
			[[fallthrough]];
		case 21:
			vy += 0x10 / ts;
			if (act_wait && cbRect.cbBottom)
			{
				gameFunc->PlaySound(L"CS_035_explosion1");
				gameFunc->SetQuake(gameFunc->game, 40, 0);
				act_no = 0;
				vx = 0;
			}
			if (act_wait == 0)
				++act_wait;
			break;
		}
	}
	else
	{
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	ani.sprite_index = lr == 0 ? L"ls_bar_close" : L"ls_bar_open";
}

void CS_Bar::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_bar_close" : L"ls_bar_open";
	if (lr == 0)
	{
		act_no = stateID;
	}
}

void CS_Bar::SetState(std::wstring stateName, int lr)
{
	if (lr == 0)
	{
		if (stateName == L"throw")
		{
			SetState(20, 0);
			drawBeforeOtherEntity = false;
		}
	}
}

std::shared_ptr<Entity> CreateCS_Bar()
{
	return std::make_shared<CS_Bar>();
}
