#pragma once
#include "Entity.h"
#include "EntityState.h"
#include "EntityStateGravity.h"
#include "EntityStateSplash.h"
#include "CS_PeDizzy.h"
#include "PeLightTail.h"
#include "CS_QuoteTeleport.h"
#define CS_AROWANAANI_CREATENAME L"CS_arowana_animate"
//
class CS_ArowanaAni :
    public Entity
{
public:
    CS_ArowanaAni();
    void Init(std::weak_ptr<Entity> self) override;
    void Step() override;
    void SetState(int stateID, int lr) override;
    void SetState(std::wstring stateName, int lr) override;
    void Destroy() override;
    //
    int stateID = 0;
    int face = 0;
    float animation_moveSpeed = 0x200 / ts;
    float floatSrcX = 0;//λ
    float floatSrcY = 0;
    bool bSetTarget = false;
    std::weak_ptr<Entity> animation_target;
    //״̬ģ
    EntityStateGravity stateGravity;
    EntityStateSplash stateSplash;
    std::weak_ptr<CS_PeDizzy> peDizzy;
    std::weak_ptr<PeLightTail> lightTail;
    bool bShowDizzy = false;
    bool bSetQuake = false;
    bool bShowSilkRibbon = false;
    int wink_counter = 0;
    int act_wait = 0;
    void AnimateStep();//
    CS_QuoteTeleport stateTeleport;
};

std::shared_ptr<Entity> CreateCS_ArowanaAni();