#include "CS_AmEMP.h"
#include "CS_Enemy_LaserTrapBlade.h"
CS_AmEMP::CS_AmEMP()
{
    type = 2;
    //
    noDir = true;
    action_timecounter = action_timecounter_max = 30;
}

void CS_AmEMP::Init(std::weak_ptr<Entity> self)
{
    if (gameFunc->pGameOption_difficulty)
        if (*gameFunc->pGameOption_difficulty == 0)
            bNormalMode = true;
    if (bNormalMode)
        existTime = 140;
    Entity::Init(self);
}

void CS_AmEMP::Step()
{
    if (r < 40 * 16.0f)
    {
        if(bNormalMode)
            r *= 1.02f;
        else
            r *= 1.05f;
    } 
    if (existTime > 0)
        existTime--;
    if (existTime == 0)
        bLeave = true;
    alpha = (BYTE)(0xff * action_timecounter / action_timecounter_max);
    color = RGBA(0xff, 0xff, 0xff, alpha);
    //ù
    float dRadian = 8 / r;
    for (float i = 0; i < XM_2PI; i += dRadian)
    {
        auto am = SetCS_Enemy_LaserTrapBlade(shared_from_this(), x + r * cosf(i), y + r * sinf(i));
        am->exist_time = 1;//ֻһغ
    }
    //Բİ뾶
    GenerateWavyCircle(0, 0, r, (int)(r * 2), 1, 1, 16);
    DrawPolyline();
    if (bLeave && action_timecounter > 0)
    {
        action_timecounter--;
        if (action_timecounter == 0)
            Destroy();
    }
    //ִ˶
    Entity::Step();
}

// ɲԲߵĵ㼯
void CS_AmEMP::GenerateWavyCircle(
    float centerX, float centerY,  // Բ
    float radius,                  // 뾶
    int segments,                  // ֶ(ԽԽԲ)
    float waveAmplitude,           // 
    int waveFrequency,             // Ƶ()
    float noiseAmplitude)    // (ѡ)
{
    polyline.clear();

    for (int i = 0; i <= segments; ++i)
    {
        float angle = XM_2PI * i / segments;

        // Բϵĵ
        float baseX = centerX + radius * cos(angle);
        float baseY = centerY + radius * sin(angle);

        // ӲЧ
        float waveOffset = waveAmplitude * sin(angle * waveFrequency);

        // (ѡ)
        float noise = noiseAmplitude * (std::rand() % 100 / 100.0f - 0.5f);

        // յλ
        float finalRadius = radius + waveOffset + noise;
        CS_AmEMP::Point p;
        p.x = centerX + finalRadius * cos(angle);
        p.y = centerY + finalRadius * sin(angle);

        polyline.push_back(p);
    }
}

// 
void CS_AmEMP::DrawPolyline()
{
    if (polyline.size() < 2)
        return;

    int index = 0;
    fillList.clear();
    DWORD c = RGBA(0, 0, 0xff, alpha);
    for (size_t i = 0; i < polyline.size() - 1; ++i)
        index += AddFillLine(fillList, index, polyline[i].x, polyline[i].y, c, polyline[i + 1].x, polyline[i + 1].y, c, 1);
    //β
    index += AddFillLine(fillList, index, polyline.back().x, polyline.back().y, c, polyline.front().x, polyline.front().y, c, 1);
}

std::shared_ptr<Entity> CreateCS_AmEMP()
{
    return std::make_shared<CS_AmEMP>();
}
