#include "UiGameKey.h"

UiGameKey::UiGameKey()
{
	ani.png = L"menu_key";
	last_x = x = -100;
	last_y = y = -100;
	ani.hideLayerList.insert(1);
}

void UiGameKey::Step()
{
	if (!gameFunc)
		return;
	int (*GameFunc:: * GetPlayerControllerType)() = nullptr;
	InputSetting_Keyboard* (*GameFunc:: * GetInputSettingKeyboard)() = nullptr;
	InputSetting_Joystick* (*GameFunc:: * GetInputSettingJoystick)() = nullptr;
	switch (playerIndex)
	{
	case 0:
		GetPlayerControllerType = &GameFunc::GetPlayer1ControllerType;
		GetInputSettingKeyboard = &GameFunc::GetInputSetting_Player1Keyboard;
		GetInputSettingJoystick = &GameFunc::GetInputSetting_Player1Joystick;
		break;
	case 1:
		GetPlayerControllerType = &GameFunc::GetPlayer2ControllerType;
		GetInputSettingKeyboard = &GameFunc::GetInputSetting_Player2Keyboard;
		GetInputSettingJoystick = &GameFunc::GetInputSetting_Player1Joystick;
		break;
	}
	auto controllerType = (gameFunc->*GetPlayerControllerType)();
	if (controllerType == 0)//
	{
		auto setting = (gameFunc->*GetInputSettingKeyboard)();
		switch (keyIndex)
		{
		case 0:
			gameFunc->GetScanCodeName(&name, setting->op_up);
			break;
		case 1:
			gameFunc->GetScanCodeName(&name, setting->op_down);
			break;
		case 2:
			gameFunc->GetScanCodeName(&name, setting->op_left);
			break;
		case 3:
			gameFunc->GetScanCodeName(&name, setting->op_right);
			break;
		case 4:
			gameFunc->GetScanCodeName(&name, setting->op_ok);
			break;
		case 5:
			gameFunc->GetScanCodeName(&name, setting->op_cancel);
			break;
		case 6:
			gameFunc->GetScanCodeName(&name, setting->op_jump);
			break;
		case 7:
			gameFunc->GetScanCodeName(&name, setting->op_atk);
			break;
		case 8:
			gameFunc->GetScanCodeName(&name, setting->op_menu);
			break;
		case 9:
			gameFunc->GetScanCodeName(&name, setting->op_inventory);
			break;
		case 10:
			gameFunc->GetScanCodeName(&name, setting->op_map);
			break;
		case 11:
			gameFunc->GetScanCodeName(&name, setting->op_pagePrev);
			break;
		case 12:
			gameFunc->GetScanCodeName(&name, setting->op_pageNext);
			break;
		case 13:
			gameFunc->GetScanCodeName(&name, setting->op_switchMc);
			break;
		case 14:
			gameFunc->GetScanCodeName(&name, setting->op_skill_1);
			break;
		case 15:
			gameFunc->GetScanCodeName(&name, setting->op_skill_2);
			break;
		case 16:
			gameFunc->GetScanCodeName(&name, setting->op_skill_3);
			break;
		case 17:
			gameFunc->GetScanCodeName(&name, setting->op_skill_4);
			break;
		case 18:
			gameFunc->GetScanCodeName(&name, setting->op_skill_5);
			break;
		case 19:
			gameFunc->GetScanCodeName(&name, setting->op_skill_6);
			break;
		}
		//ͼ
		ani.sprite_index.clear();
		ani.sprite_index.append(L"keyboard_");
		ani.sprite_index.append(name.data());
	}
	else//ֱ
	{
		auto setting = (gameFunc->*GetInputSettingJoystick)();
		switch (keyIndex)
		{
		case 0:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_up);
			break;
		case 1:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_down);
			break;
		case 2:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_left);
			break;
		case 3:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_right);
			break;
		case 4:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_ok);
			break;
		case 5:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_cancel);
			break;
		case 6:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_jump);
			break;
		case 7:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_atk);
			break;
		case 8:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_menu);
			break;
		case 9:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_inventory);
			break;
		case 10:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_map);
			break;
		case 11:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_pagePrev);
			break;
		case 12:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_pageNext);
			break;
		case 13:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_switchMc);
			break;
		case 14:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_skill_1);
			break;
		case 15:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_skill_2);
			break;
		case 16:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_skill_3);
			break;
		case 17:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_skill_4);
			break;
		case 18:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_skill_5);
			break;
		case 19:
			gameFunc->GetGameControllerKeyName(&name, &setting->op_skill_6);
			break;
		}
		//ͼ
		ani.sprite_index.clear();
		ani.sprite_index.append(L"joystick_");
		ani.sprite_index.append(name.data());
	}
}

void UiGameKey::SetDisplay(int playerIndex, int keyIndex)
{
	this->playerIndex = playerIndex;
	this->keyIndex = keyIndex;
}
