#include "ScriptCmd.h"
#include "main.h"
#include "MyGame.h"
void ScriptCmd::Init(MyGame* game)
{
	this->game = game;
	pView = game->pView;
	pGameMap = &game->gameMap;
	pMapDrawer = game->stageDrawer.GetMapDrawer();
	pGameScrpt = &game->gameScript;
	pGameMsgbox = &game->gameMsgbox;
	pEntityRes = &game->entityRes;
	pGameFade = &game->gameFade;
	pCamera = &game->myCamera;
	pGameUI = &game->gameUI;
	pFlagSet = &game->flagSet;
	pSkipSet = &game->skipSet;
	dmgNum = &game->dmgNum;
	pMapSystem = &game->mapSystem;
	pItemSystem = &game->itemSystem;
	pCheckEventPlayerIndex = &game->checkEventPlayerIndex;
	mychar_ptr_Player1 = &game->mychar_player1;
	mychar_ptr_Player2 = &game->mychar_player2;
	globalEntityTable = &game->globalEntityTable;
	globalEntity = &game->globalEntity;
	globalEntity_addList = &game->globalEntity_addList;
}

void ScriptCmd::TRA(const char* mapName_utf8, const char* eventName_utf8, int x, int y)
{
	UTF8ToUTF16(mapName_utf8, &wbuff);
	UTF8ToUTF16(eventName_utf8, &wbuff2);
	pGameScrpt->TRA(wbuff.data(), wbuff2.data());

	for (auto& wplayer : *globalEntity)
	{
		wplayer->entityLayer = nullptr;
		wplayer->cbRect.pxmArr = nullptr;
		wplayer->cbRect.pxaArr = nullptr;
		wplayer->cbRect.Collision = nullptr;
		if (!wplayer->inUsing)
			continue;
		wplayer->SetState(0, wplayer->lr);
		pEntityRes->MoveEntity(wplayer, x, y);
		if (!wplayer->hide)
		{
			wplayer->input.key = 0;
			wplayer->Step();
		}
	}
	FOM(16);
	pEntityRes->Reset();
	pMapDrawer->Reset();
	dmgNum->Reset();
	pCamera->ResetQuake();
}

void ScriptCmd::TRA(const char* mapName_utf8, const char* eventName_utf8, int x, int y, int hv, int offset)
{
	UTF8ToUTF16(mapName_utf8, &wbuff);
	UTF8ToUTF16(eventName_utf8, &wbuff2);
	pGameScrpt->TRA(wbuff.data(), wbuff2.data());

	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();

	for (auto& wplayer : *globalEntity)
	{
		wplayer->SetState(0, wplayer->lr);
		wplayer->entityLayer = nullptr;
		wplayer->cbRect.pxmArr = nullptr;
		wplayer->cbRect.pxaArr = nullptr;
		wplayer->cbRect.Collision = nullptr;
		if (!wplayer->hide)
			wplayer->Step();
		if (wplayer == players[*pCheckEventPlayerIndex].lock())
		{
			if (hv == 0)
			{
				float dx = wplayer->x - 8 - offset * 16;
				pEntityRes->MoveEntity(wplayer, x, y);
				wplayer->x += dx;
			}
			else
			{
				float dy = wplayer->y - 8 - offset * 16;
				pEntityRes->MoveEntity(wplayer, x, y);
				wplayer->y += dy;
			}
		}
		else
		{
			pEntityRes->MoveEntity(wplayer, x, y);
		}
	}
	pEntityRes->Reset();
	pMapDrawer->Reset();
	dmgNum->Reset();
	pCamera->ResetQuake();
}

void ScriptCmd::DBG(const char* str_utf8)
{
	UTF8ToUTF16(str_utf8, &wbuff);
	MessageBoxW(hwnd, wbuff.data(), L"luaű", MB_OK);
}

void ScriptCmd::WAI(int wait)
{
	pGameScrpt->SetWait(wait);
}

void ScriptCmd::WAS()
{
	pGameScrpt->SetWAS();
}

void ScriptCmd::STY(const char* msgboxStyle_utf8)
{
	UTF8ToUTF16(msgboxStyle_utf8, &wbuff);
	pGameMsgbox->STY(wbuff.data());
}

void ScriptCmd::MSG(const char* msg_utf8, int mode)
{
	UTF8ToUTF16(msg_utf8, &wbuff);
	pGameMsgbox->MSG(wbuff.data(), mode);
}

void ScriptCmd::MS2(const char* msg_utf8, int mode)
{
	UTF8ToUTF16(msg_utf8, &wbuff);
	pGameMsgbox->MS2(wbuff.data(), mode);
}

void ScriptCmd::MS3(const char* msg_utf8, int mode)
{
	UTF8ToUTF16(msg_utf8, &wbuff);
	pGameMsgbox->MS3(wbuff.data(), mode);
}

void ScriptCmd::MS4(const char* msg_utf8, int mode)
{
	UTF8ToUTF16(msg_utf8, &wbuff);
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[*pCheckEventPlayerIndex].lock();
	if (wplayer)
		pGameMsgbox->AutoMSG(wbuff.data(), mode, wplayer->y);
}

void ScriptCmd::MSS(int speed)
{
	pGameMsgbox->MSS(speed);
}

void ScriptCmd::TUR(bool tur)
{
	pGameMsgbox->TUR(tur);
}

void ScriptCmd::NOD()
{
	pGameMsgbox->NOD();
}

void ScriptCmd::CAT(const char* msg_utf8, int mode)
{
	UTF8ToUTF16(msg_utf8, &wbuff);
	pGameMsgbox->CAT(wbuff.data(), mode);
}

void ScriptCmd::CLR()
{
	pGameMsgbox->CLR();
}

void ScriptCmd::CLO()
{
	pGameMsgbox->CLO();
}

void ScriptCmd::FCL(BYTE r, BYTE g, BYTE b, BYTE a)
{
	pGameMsgbox->FCL(r, g, b, a);
}

void ScriptCmd::FNT(const char* fontFamily_utf8)
{
	UTF8ToUTF16(fontFamily_utf8, &wbuff);
	pGameMsgbox->FNT(wbuff.data());
}

void ScriptCmd::FSZ()
{
	pGameMsgbox->FSZ();
}

void ScriptCmd::FSZ(int fontSize)
{
	pGameMsgbox->FSZ(fontSize);
}

void ScriptCmd::FAC(const char* faceID)
{
	UTF8ToUTF16(faceID, &wbuff);
	pGameMsgbox->FAC(wbuff.data());
}

void ScriptCmd::FAC()
{
	pGameMsgbox->FAC(L"");
}

void ScriptCmd::CMU(const char* musicName_utf8, float fadeInSecond)
{
	UTF8ToUTF16(musicName_utf8, &wbuff);
	orgPlayer.ChangeMusic(wbuff.data(), fadeInSecond);
}

void ScriptCmd::PMU(float fadeOutSecond)
{
	if (fadeOutSecond > 0)
		orgPlayer.FadeOutMusic(fadeOutSecond);
	else
		orgPlayer.StopMusic();
}

void ScriptCmd::RMU(float fadeInSecond)
{
	orgPlayer.ResumeMusic(fadeInSecond);
}

void ScriptCmd::SOU(const char* soundName_utf8)
{
	UTF8ToUTF16(soundName_utf8, &wbuff);
	PlaySound(wbuff.data());
}

void ScriptCmd::CMU2(const char* musicName_utf8, float fadeInSecond)
{
	UTF8ToUTF16(musicName_utf8, &wbuff);
	pMusic.ChangeMusic(wbuff.data(), fadeInSecond);
}

void ScriptCmd::PMU2(float fadeOutSecond)
{
	if (fadeOutSecond > 0)
		pMusic.FadeOutMusic(fadeOutSecond);
	else
		pMusic.StopMusic();
}

void ScriptCmd::RMU2(float fadeInSecond)
{
	pMusic.ResumeMusic(fadeInSecond);
}

void ScriptCmd::PRI()
{
	pGameScrpt->SetPRI(true);
}

void ScriptCmd::KEY(bool bKey)
{
	pGameScrpt->SetPRI(false);
	pGameScrpt->SetKEY(bKey);
}

void ScriptCmd::MM0()
{
	for (auto& wplayer : *globalEntity)
		wplayer->vx = 0;
}

void ScriptCmd::MM0(int playerIndex)
{
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[playerIndex].lock();
	if (wplayer)
		wplayer->vx = 0;
}

void ScriptCmd::MV0()
{
	for (auto& wplayer : *globalEntity)
	{
		wplayer->vx = 0;
		wplayer->vy = 0;
	}
}

void ScriptCmd::MV0(int playerIndex)
{
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[playerIndex].lock();
	if (wplayer)
	{
		wplayer->vx = 0;
		wplayer->vy = 0;
	}
}

void ScriptCmd::MOV(int x, int y)
{
	for (auto& player : *globalEntity)
		pEntityRes->MoveEntity(player, x, y);
}

void ScriptCmd::MOV(int x, int y, int hv, int offset)
{
	for (auto& wplayer : *globalEntity)
	{
		if (hv == 0)
		{
			float dx = wplayer->x - 8 - offset * 16;
			pEntityRes->MoveEntity(wplayer, x, y);
			wplayer->x += dx;
		}
		else
		{
			float dy = wplayer->y - 8 - offset * 16;
			pEntityRes->MoveEntity(wplayer, x, y);
			wplayer->y += dy;
		}
	}
}

void ScriptCmd::MOV(int x, int y, int playerIndex)
{
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	std::weak_ptr<Entity> player = players[playerIndex];
	pEntityRes->MoveEntity(player, x, y);
}

void ScriptCmd::MOV(int x, int y, int hv, int offset, int playerIndex)
{
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[playerIndex].lock();
	if (wplayer)
	{
		if (hv == 0)
		{
			float dx = wplayer->x - 8 - offset * 16;
			pEntityRes->MoveEntity(wplayer, x, y);
			wplayer->x += dx;
		}
		else
		{
			float dy = wplayer->y - 8 - offset * 16;
			pEntityRes->MoveEntity(wplayer, x, y);
			wplayer->y += dy;
		}
	}
}

void ScriptCmd::MOV(int x, int y, const char* globalEntityID_utf8)
{
	UTF8ToUTF16(globalEntityID_utf8, &wbuff);
	auto iter = globalEntityTable->find(wbuff.data());
	if (iter == globalEntityTable->end())
		return;
	pEntityRes->MoveEntity(iter->second, x, y);
}

void ScriptCmd::MOV(int x, int y, int hv, int offset, const char* globalEntityID_utf8)
{
	UTF8ToUTF16(globalEntityID_utf8, &wbuff);
	auto iter = globalEntityTable->find(wbuff.data());
	if (iter == globalEntityTable->end())
		return;
	auto wplayer = iter->second.lock();
	if (wplayer)
	{
		if (hv == 0)
		{
			float dx = wplayer->x - 8 - offset * 16;
			pEntityRes->MoveEntity(wplayer, x, y);
			wplayer->x += dx;
		}
		else
		{
			float dy = wplayer->y - 8 - offset * 16;
			pEntityRes->MoveEntity(wplayer, x, y);
			wplayer->y += dy;
		}
	}
}

void ScriptCmd::MOV(const char* eventName_utf8)
{
	UTF8ToUTF16(eventName_utf8, &wbuff);
	for (auto& player : *globalEntity)
		pEntityRes->MoveEntity(player, wbuff.data());
}

void ScriptCmd::MOV(const char* eventName_utf8, int playerIndex)
{
	UTF8ToUTF16(eventName_utf8, &wbuff);
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	std::weak_ptr<Entity> player = players[playerIndex];
	pEntityRes->MoveEntity(player, wbuff.data());
}

void ScriptCmd::MOV(int playerIndex)
{
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[playerIndex].lock();
	if (wplayer)
	{
		for (auto& player : *globalEntity)
		{
			if (player == wplayer)
				continue;
			player->last_x = player->x = wplayer->x;
			player->last_y = player->y = wplayer->y;
		}
	}
}

void ScriptCmd::SLR(int lr)
{
	for (auto& wplayer : *globalEntity)
		wplayer->lr = lr;
}

void ScriptCmd::SLR(int lr, int playerIndex)
{
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[playerIndex].lock();
	if (wplayer)
		wplayer->lr = lr;
}

void ScriptCmd::SLR(const char* eventName_utf8, int playerIndex)
{
	UTF8ToUTF16(eventName_utf8, &wbuff);
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[playerIndex].lock();
	auto we = pEntityRes->GetEntity(wbuff.data()).lock();
	if (we)
	{
		wplayer->lr = wplayer->x > we->x ? 0 : 1;
	}
	else
	{
		auto iter = globalEntityTable->find(wbuff.data());
		if (iter != globalEntityTable->end())
		{
			we = iter->second.lock();
			if(we)
				wplayer->lr = wplayer->x > we->x ? 0 : 1;
		}
	}
}

void ScriptCmd::SLR(const char* eventName_utf8)
{
	UTF8ToUTF16(eventName_utf8, &wbuff);
	auto we = pEntityRes->GetEntity(wbuff.data()).lock();
	if (we)
	{
		for (auto& wplayer : *globalEntity)
		{
			wplayer->lr = wplayer->x > we->x ? 0 : 1;
		}
	}
	else
	{
		auto iter = globalEntityTable->find(wbuff.data());
		if (iter != globalEntityTable->end())
		{
			we = iter->second.lock();
			if (we)
			{
				for (auto& wplayer : *globalEntity)
				{
					if (we == wplayer)
						continue;
					wplayer->lr = wplayer->x > we->x ? 0 : 1;
				}
			}
		}
	}
}

int ScriptCmd::GLR(int playerIndex)
{
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[playerIndex].lock();
	if (wplayer)
		return wplayer->lr;
	return 0;
}

void ScriptCmd::MYB(int lr)
{
	for (auto& wplayer : *globalEntity)
	{
		wplayer->vy = -1;
		if (lr == 0)
		{
			//
			wplayer->vx = 1;
		}
		else
		{
			//
			wplayer->vx = -1;
		}
	}
}

void ScriptCmd::MYB(int lr, int playerIndex)
{
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[playerIndex].lock();
	if (wplayer)
	{
		wplayer->vy = -1;
		if (lr == 0)
		{
			//
			wplayer->vx = 1;
		}
		else
		{
			//
			wplayer->vx = -1;
		}
	}
}

void ScriptCmd::FON(const char* eventName_utf8, float focusTimes)
{
	UTF8ToUTF16(eventName_utf8, &wbuff);
	auto we = pEntityRes->GetEntity(wbuff.data()).lock();
	if (!we)
		return;
	pCamera->EnableLRUD(false);
	pCamera->SetTarget(we, focusTimes);
	pCamera->SetTarget2(std::weak_ptr<Entity>());
	if (focusTimes == 0)
		pCamera->FocusOnce();
}

void ScriptCmd::FOM(float focusTimes)
{
	pCamera->EnableLRUD(true);
	pCamera->SetTarget(pEntityRes->GetMyChar_Player1(), focusTimes);
	auto wplayer2 = pEntityRes->GetMyChar_Player2().lock();
	if (wplayer2 && wplayer2->el.name != L"null")
		pCamera->SetTarget2(wplayer2);
	else
		pCamera->SetTarget2(std::weak_ptr<Entity>());
	if (focusTimes == 0)
		pCamera->FocusOnce();
}

void ScriptCmd::FOM(float focusTimes, int playerIndex)
{
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[playerIndex].lock();
	pCamera->SetTarget2(std::weak_ptr<Entity>());
	pCamera->SetTarget(wplayer, focusTimes);
	if (focusTimes == 0)
		pCamera->Step();
}

void ScriptCmd::MNA()
{
	pMapDrawer->MNA();
}

void ScriptCmd::FAI(int direction)
{
	pGameFade->FAI(direction);
}

void ScriptCmd::FAO(int direction)
{
	pGameFade->FAO(direction);
}

void ScriptCmd::HMC()
{
	for (auto& wplayer : *globalEntity)
		wplayer->hide = true;
}

void ScriptCmd::HMC(int playerIndex)
{
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[playerIndex].lock();
	if (wplayer)
		wplayer->hide = true;
}

void ScriptCmd::HMC(const char* globalEntityID_utf8)
{
	UTF8ToUTF16(globalEntityID_utf8, &wbuff);
	auto iter = globalEntityTable->find(wbuff.data());
	if (iter == globalEntityTable->end())
		return;
	auto wplayer = iter->second.lock();
	if (wplayer)
		wplayer->hide = true;
}

void ScriptCmd::SMC()
{
	for (auto& wplayer : *globalEntity)
		wplayer->hide = false;
}

void ScriptCmd::SMC(int playerIndex)
{
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[playerIndex].lock();
	if (wplayer)
		wplayer->hide = false;
}

void ScriptCmd::SMC(const char* globalEntityID_utf8)
{
	UTF8ToUTF16(globalEntityID_utf8, &wbuff);
	auto iter = globalEntityTable->find(wbuff.data());
	if (iter == globalEntityTable->end())
		return;
	auto wplayer = iter->second.lock();
	if (wplayer)
		wplayer->hide = false;
}

void ScriptCmd::ANP(int stateID)
{
	auto we = pGameScrpt->GetCheckEntity().lock();
	if (we)
		we->SetState(stateID, we->lr);
}

void ScriptCmd::ANP(const char* eventName_utf8, int stateID, int lr)
{
	UTF8ToUTF16(eventName_utf8, &wbuff);
	pEntityRes->ANP(wbuff.data(), stateID, lr);
}

void ScriptCmd::ANP(const char* eventName_utf8, int stateID)
{
	UTF8ToUTF16(eventName_utf8, &wbuff);
	pEntityRes->ANP(wbuff.data(), stateID);
}

void ScriptCmd::ANP(const char* stateName_utf8)
{
	UTF8ToUTF16(stateName_utf8, &wbuff);
	auto we = pGameScrpt->GetCheckEntity().lock();
	if (we)
		we->SetState(wbuff.data(), we->lr);
}

void ScriptCmd::ANP(const char* eventName_utf8, const char* stateName_utf8, int lr)
{
	UTF8ToUTF16(eventName_utf8, &wbuff);
	UTF8ToUTF16(stateName_utf8, &wbuff2);
	pEntityRes->ANP(wbuff.data(), wbuff2.data(), lr);
}

void ScriptCmd::ANP(const char* eventName_utf8, const char* stateName_utf8)
{
	UTF8ToUTF16(eventName_utf8, &wbuff);
	UTF8ToUTF16(stateName_utf8, &wbuff2);
	pEntityRes->ANP(wbuff.data(), wbuff2.data());
}

void ScriptCmd::AMC(int stateID)
{
	for (auto& wplayer : *globalEntity)
	{
		if (wplayer->hide)
			continue;
		wplayer->SetState(stateID, wplayer->lr);
	}
}

void ScriptCmd::AMC(int stateID, int lr)
{
	for (auto& wplayer : *globalEntity)
	{
		if (wplayer->hide)
			continue;
		wplayer->SetState(stateID, lr);
	}
}

void ScriptCmd::AMC(int stateID, int lr, int playerIndex)
{
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[playerIndex].lock();
	if (wplayer && !wplayer->hide)
		wplayer->SetState(stateID, lr);
}

void ScriptCmd::AMC(int stateID, int lr, const char* globalEntityID_utf8)
{
	UTF8ToUTF16(globalEntityID_utf8, &wbuff);
	auto iter = globalEntityTable->find(wbuff.data());
	if (iter == globalEntityTable->end())
		return;
	auto wplayer = iter->second.lock();
	if (wplayer && !wplayer->hide)
		wplayer->SetState(stateID, lr);
}

void ScriptCmd::AMC(int stateID, const char* mycharName_utf8)
{
	UTF8ToUTF16(mycharName_utf8, &wbuff);
	for (auto& wplayer : *globalEntity)
	{
		if (wplayer->hide)
			continue;
		if (wplayer->el.name == wbuff.data())
			wplayer->SetState(stateID, wplayer->lr);
	}
}

void ScriptCmd::AMC(const char* stateName_utf8)
{
	UTF8ToUTF16(stateName_utf8, &wbuff);
	for (auto& wplayer : *globalEntity)
	{
		if (wplayer->hide)
			continue;
		wplayer->SetState(wbuff.data(), wplayer->lr);
	}
}

void ScriptCmd::AMC(const char* stateName_utf8, int lr)
{
	UTF8ToUTF16(stateName_utf8, &wbuff);
	for (auto& wplayer : *globalEntity)
	{
		if (wplayer->hide)
			continue;
		wplayer->SetState(wbuff.data(), lr);
	}
}

void ScriptCmd::AMC(const char* stateName_utf8, int lr, int playerIndex)
{
	UTF8ToUTF16(stateName_utf8, &wbuff);
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[playerIndex].lock();
	if (wplayer && !wplayer->hide)
		wplayer->SetState(wbuff.data(), lr);
}

void ScriptCmd::AMC(const char* stateName_utf8, int lr, const char* globalEntityID_utf8)
{
	UTF8ToUTF16(stateName_utf8, &wbuff);
	UTF8ToUTF16(globalEntityID_utf8, &wbuff2);
	auto iter = globalEntityTable->find(wbuff2.data());
	if (iter == globalEntityTable->end())
		return;
	auto wplayer = iter->second.lock();
	if (wplayer && !wplayer->hide)
		wplayer->SetState(wbuff.data(), lr);
}

void ScriptCmd::AMC(const char* stateName_utf8, const char* mycharName_utf8)
{
	UTF8ToUTF16(mycharName_utf8, &wbuff);
	UTF8ToUTF16(stateName_utf8, &wbuff2);
	for (auto& wplayer : *globalEntity)
	{
		if (wplayer->hide)
			continue;
		if (wplayer->el.name == wbuff.data())
			wplayer->SetState(wbuff2.data(), wplayer->lr);
	}
}

void ScriptCmd::ATP(const char* npcName_utf8, const char* stateName_utf8)
{
	UTF8ToUTF16(npcName_utf8, &wbuff);
	UTF8ToUTF16(stateName_utf8, &wbuff2);
	pEntityRes->ATP(wbuff.data(), wbuff2.data());
}

void ScriptCmd::TMC(bool enable)
{
	for (auto& wplayer : *globalEntity)
		wplayer->topDraw = enable;
}

void ScriptCmd::TMC(bool enable, int playerIndex)
{
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[playerIndex].lock();
	if (wplayer)
		wplayer->topDraw = enable;
}

void ScriptCmd::TNP(const char* eventName_utf8, bool enable)
{
	UTF8ToUTF16(eventName_utf8, &wbuff);
	pEntityRes->SetNpcTopDraw(wbuff.data(), enable);
}

void ScriptCmd::CNP(const char* eventName_utf8, const char* npcName_utf8, int stateID, int lr)
{
	UTF8ToUTF16(eventName_utf8, &wbuff);
	UTF8ToUTF16(npcName_utf8, &wbuff2);
	pEntityRes->ChangeNpc(wbuff.data(), wbuff2.data(), stateID, lr);
}

void ScriptCmd::CNP(const char* eventName_utf8, const char* npcName_utf8, int stateID)
{
	UTF8ToUTF16(eventName_utf8, &wbuff);
	UTF8ToUTF16(npcName_utf8, &wbuff2);
	pEntityRes->ChangeNpc(wbuff.data(), wbuff2.data(), stateID);
}

void ScriptCmd::CNP(const char* eventNameSrc_utf8, const char* eventNameDst_utf8)
{
	UTF8ToUTF16(eventNameSrc_utf8, &wbuff);
	UTF8ToUTF16(eventNameDst_utf8, &wbuff2);
	auto weSrc = pEntityRes->GetEntity(wbuff.data()).lock();
	auto weDst = pEntityRes->GetEntity(wbuff2.data()).lock();
	if (weSrc && weDst)
	{
		weSrc->el.eventName = weDst->el.eventName;
		weSrc->el.flag = weDst->el.flag;
		weSrc->el.eid = weDst->el.eid;
		weSrc->el.arg = weDst->el.arg;
		weSrc->el.arg2 = weDst->el.arg2;
		weSrc->el.arg3 = weDst->el.arg3;
	}
}

void ScriptCmd::MNP(const char* eventName_utf8, int x, int y, int lr)
{
	UTF8ToUTF16(eventName_utf8, &wbuff);
	pEntityRes->MoveNpc(wbuff.data(), x, y, lr);
}

void ScriptCmd::MNP(const char* eventName_utf8, const char* dstEventName_utf8)
{
	UTF8ToUTF16(eventName_utf8, &wbuff);
	UTF8ToUTF16(dstEventName_utf8, &wbuff2);
	pEntityRes->MoveNpc(wbuff.data(), wbuff2.data());
}

void ScriptCmd::BSL(const char* eventName_utf8, int lineSize)
{
	UTF8ToUTF16(eventName_utf8, &wbuff);
	auto e = pEntityRes->GetEntity(wbuff.data());
	pGameUI->GetBossHpBar()->BossReady(e, lineSize);
}

void ScriptCmd::BSL(const char* eventName_utf8)
{
	UTF8ToUTF16(eventName_utf8, &wbuff);
	auto we = pEntityRes->GetEntity(wbuff.data()).lock();
	if (we)
		pGameUI->GetBossHpBar()->BossReady(we, we->hp);
}

void ScriptCmd::SAV()
{
	std::list<Entity> positionSaver;//걣
	for (auto& p : *globalEntityTable)
	{
		auto we = p.second.lock();
		if (we)
		{
			Entity e;
			e.x = we->x;
			e.y = we->y;
			e.last_x = we->last_x;
			e.last_y = we->last_y;
			e.globalEntityID = we->globalEntityID;
			positionSaver.push_back(e);
		}
	}
	//ƶߵλ
	if (*pCheckEventPlayerIndex == 0)
	{
		auto wplayer1 = (*mychar_ptr_Player1).lock();
		if (wplayer1)
		{
			for (auto& p : *globalEntityTable)
			{
				auto we = p.second.lock();
				if (we)
				{
					we->x = wplayer1->x;
					we->y = wplayer1->y;
				}
			}
		}
	}
	else if (*pCheckEventPlayerIndex == 1)
	{
		auto wplayer2 = (*mychar_ptr_Player1).lock();
		if (wplayer2)
		{
			for (auto& p : *globalEntityTable)
			{
				auto we = p.second.lock();
				if (we)
				{
					we->x = wplayer2->x;
					we->y = wplayer2->y;
				}
			}
		}
	}
	SaveGameToFile();
	if (positionSaver.empty())
		return;
	for (auto& p : *globalEntityTable)
	{
		auto we = p.second.lock();
		if (we)
		{
			for (auto& posE : positionSaver)
			{
				if (posE.globalEntityID == we->globalEntityID)
				{
					we->x = posE.x;
					we->y = posE.y;
					we->last_x = posE.last_x;
					we->last_y = posE.last_y;
					break;
				}
			}
		}
	}
}

void ScriptCmd::LAY(const char* layerName_utf8, bool bVisible)
{
	UTF8ToUTF16(layerName_utf8, &wbuff);
	auto mapLayer = pGameMap->GetMapLayer(wbuff.data());
	if (mapLayer)
		mapLayer->visible = bVisible;
}

void ScriptCmd::FLP(const char* flagName_utf8)
{
	UTF8ToUTF16(flagName_utf8, &wbuff);
	if (pFlagSet->find(wbuff.data()) == pFlagSet->end())
		pFlagSet->insert(wbuff.data());
}

void ScriptCmd::FLS(const char* flagName_utf8)
{
	UTF8ToUTF16(flagName_utf8, &wbuff);
	pFlagSet->erase(wbuff.data());
}

bool ScriptCmd::FLJ(const char* flagName_utf8)
{
	UTF8ToUTF16(flagName_utf8, &wbuff);
	return pFlagSet->find(wbuff.data()) != pFlagSet->end();
}

void ScriptCmd::YNJ()
{
	pGameScrpt->SetYNJ();
}

bool ScriptCmd::YES()
{
	return pGameScrpt->GetYES();
}

void ScriptCmd::INI()
{
	GameRestart();
}

void ScriptCmd::ESC()
{
	GameBackTitle();
}

void ScriptCmd::W99()
{
	pGameScrpt->SetW99(true);
}

void ScriptCmd::MAP()
{
	pMapSystem->SetShow(true);
}

int ScriptCmd::PLY()
{
	return *pCheckEventPlayerIndex;
}

void ScriptCmd::SNP(const char* npcName_utf8, int x, int y, int lr, const char* layerName_utf8, const char* eventName_utf8)
{
	UTF8ToUTF16(npcName_utf8, &wbuff);
	const wchar_t* layerName = nullptr;
	if (layerName_utf8)
	{
		UTF8ToUTF16(layerName_utf8, &wbuff2);
		layerName = wbuff2.data();
	}
	const wchar_t* eventName = nullptr;
	if (eventName_utf8)
	{
		UTF8ToUTF16(eventName_utf8, &wbuff3);
		eventName = wbuff3.data();
	}
	pEntityRes->SetNpc(wbuff.data(), x, y, lr, layerName, eventName);
}

void ScriptCmd::DNP(const char* eventName_utf8)
{
	UTF8ToUTF16(eventName_utf8, &wbuff);
	pEntityRes->DeleteNpc(wbuff.data());
}

void ScriptCmd::DNP()
{
	pEntityRes->DeleteNpc(pGameScrpt->GetCheckEntity());
}

void ScriptCmd::MLP(int val)
{
	for (auto& wplayer : *globalEntity)
		wplayer->hp_max += val;
	LIP(val);
}

void ScriptCmd::MLP(int val, int playerIndex)
{
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[playerIndex].lock();
	if (wplayer)
		wplayer->hp_max += val;
	LIP(val, playerIndex);
}

bool ScriptCmd::ECJ(const char* eventName_utf8)
{
	UTF8ToUTF16(eventName_utf8, &wbuff);
	auto we = pEntityRes->GetEntity(wbuff.data()).lock();
	return we != nullptr;
}

void ScriptCmd::LIP(int val)
{
	for (auto& wplayer : *globalEntity)
	{
		wplayer->hp += val;
		if (wplayer->hp > wplayer->hp_max)
			wplayer->hp = wplayer->hp_max;
	}
}

void ScriptCmd::LIP(int val, int playerIndex)
{
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[playerIndex].lock();
	if (wplayer)
	{
		wplayer->hp += val;
		if (wplayer->hp > wplayer->hp_max)
			wplayer->hp = wplayer->hp_max;
	}
}

const char* ScriptCmd::TGR()
{
	UTF16ToUTF8(pGameScrpt->GetTriggerType(), &utf8);
	return utf8.data();
}

void ScriptCmd::ELT(const char* npcName_utf8, const char* eventName_utf8, const char* triggerType_utf8)
{
	EntityLoad el;
	UTF8ToUTF16(npcName_utf8, &wbuff);
	if (eventName_utf8)
	{
		UTF8ToUTF16(eventName_utf8, &wbuff2);
		el.eventName = wbuff2.data();
	}
	if (triggerType_utf8)
	{
		UTF8ToUTF16(triggerType_utf8, &wbuff3);
		std::wstring triggerType = wbuff3.data();
		el.flag.tCheck = triggerType == L"tCheck";
		el.flag.tTouch = triggerType == L"tTouch";
		el.flag.tDeath = triggerType == L"tDeath";
		el.flag.tCrush = triggerType == L"tCrush";
		el.flag.tHurt = triggerType == L"tHurt";
		el.flag.tDamage = triggerType == L"tDamage";
	}
	pEntityRes->SetELTable(wbuff.data(), &el);
}

void ScriptCmd::ELT(const char* npcName_utf8)
{
	UTF8ToUTF16(npcName_utf8, &wbuff);
	pEntityRes->DelELTable(wbuff.data());
}

void ScriptCmd::ELT()
{
	pEntityRes->ClrELTable();
}

void ScriptCmd::SPL(int playerIndex, const char* globalEntityID_utf8)
{
	UTF8ToUTF16(globalEntityID_utf8, &wbuff);
	auto iter = globalEntityTable->find(wbuff.data());
	if (iter == globalEntityTable->end())
		return;
	if (playerIndex == 0)
	{
		auto wplayer = mychar_ptr_Player1->lock();
		if (wplayer)
			wplayer->input.key = 0;
		*mychar_ptr_Player1 = iter->second;
	}
	else if (playerIndex == 1)
	{
		auto wplayer = mychar_ptr_Player2->lock();
		if (wplayer)
			wplayer->input.key = 0;
		*mychar_ptr_Player2 = iter->second;
	}
	pCamera->SetTarget(*mychar_ptr_Player1);
	pCamera->SetTarget2(*mychar_ptr_Player2);
	pGameUI->Reset();
}

void ScriptCmd::SGP(const char* npcName_utf8, int x, int y, int lr, const char* globalEntityID_utf8)
{
	UTF8ToUTF16(npcName_utf8, &wbuff);
	auto we = GameCreateEntity(wbuff.data());
	we->x = x * pView->grid_w + pView->grid_w / 2;
	we->y = y * pView->grid_h + pView->grid_h / 2;
	we->lr = lr;
	we->el.name = wbuff.data();
	we->gameFunc = &game->gameFunc;
	we->SetState(0, we->lr);
	if (!we->initCheck)
		we->Init(we);
	globalEntity_addList->push_back(we);
	UTF8ToUTF16(globalEntityID_utf8, &wbuff2);
	//globalEntityмǷIDɾ
	for (auto& p : *globalEntity)
	{
		if (p->globalEntityID == wbuff2.data())
		{
			p->Destroy();
			break;
		}
	}
	(*globalEntityTable)[wbuff2.data()] = we;
	we->globalEntityID = wbuff2.data();
}

void ScriptCmd::CGP(const char* srcGlobalEntityID_utf8, const char* dstGlobalEntityID_utf8)
{
	UTF8ToUTF16(srcGlobalEntityID_utf8, &wbuff);
	UTF8ToUTF16(dstGlobalEntityID_utf8, &wbuff2);
	auto iter = globalEntityTable->find(wbuff.data());
	if (iter == globalEntityTable->end())
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"ûȫʵID[%s]ĵλ", wbuff.data());
		MessageBox(hwnd, err, L"ָCGPִʧ", MB_ICONWARNING);
		return;
	}
	auto iter2 = globalEntityTable->find(wbuff2.data());
	if (iter2 != globalEntityTable->end())
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"ȫʵID[%s]ĵλѴ", wbuff2.data());
		MessageBox(hwnd, err, L"ָCGPִʧ", MB_ICONWARNING);
		return;
	}
	auto wsrcPlayer = iter->second.lock();
	if (!wsrcPlayer)
		return;
	if (wsrcPlayer->el.name.empty())
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"Ƶԭʵ%s[%s][%s]δƣ",
			wsrcPlayer->el.name.c_str(), wsrcPlayer->ani.png.c_str(), wsrcPlayer->ani.sprite_index.c_str());
		MessageBox(hwnd, err, L"ָCGPִʧ", MB_ICONWARNING);
		return;
	}
	//и
	UTF16ToUTF8(wsrcPlayer->el.name.c_str(), &utf8);
	SGP(utf8.data(), 0, 0, 0, dstGlobalEntityID_utf8);
	auto wdstPlayer = (*globalEntityTable)[wbuff2.data()].lock();
	if (wdstPlayer)
	{
		wdstPlayer->CopyFrom(wsrcPlayer);
	}
}

void ScriptCmd::DGP(const char* globalEntityID_utf8)
{
	UTF8ToUTF16(globalEntityID_utf8, &wbuff);
	auto iter = globalEntityTable->find(wbuff.data());
	if (iter == globalEntityTable->end())
		return;
	auto wplayer = iter->second.lock();
	if (wplayer)
		wplayer->Destroy();
}

void ScriptCmd::AGP(const char* globalEntityID_utf8, bool enableAI, const char* followID_utf8)
{
	UTF8ToUTF16(globalEntityID_utf8, &wbuff);
	auto iter = globalEntityTable->find(wbuff.data());
	if (iter == globalEntityTable->end())
		return;
	auto wplayer = iter->second.lock();
	if (wplayer)
	{
		wplayer->enableAI = enableAI;
		if (!enableAI)
		{
			//AI
			auto wai = wplayer->ai.lock();
			if (wai)
				wai->Destroy();
			wplayer->ai.reset();
		}
		wplayer->attackParent.reset();
		if (followID_utf8)
		{
			UTF8ToUTF16(followID_utf8, &wbuff);
			auto iter2 = globalEntityTable->find(wbuff.data());
			if (iter2 == globalEntityTable->end())
				return;
			wplayer->attackParent = iter2->second;
		}
	}
}

void ScriptCmd::P2A(bool bEnable)
{
	game->enablePlayer2AISwitch = bEnable;
}

bool ScriptCmd::WET()
{
	auto we = pGameScrpt->GetCheckEntity().lock();
	if (!we)
		return false;
	return we->cbRect.inWater;
}

const char* ScriptCmd::EID()
{
	auto we = pGameScrpt->GetCheckEntity().lock();
	if (!we)
		return "";
	UTF16ToUTF8(we->el.eid.c_str(), &utf8);
	return utf8.data();
}

void ScriptCmd::RGI(const char* regID_utf8, const char* iconEntityName_utf8,
	const char* functionName_utf8, const char* checkFunctionName_utf8, bool stackable)
{
	ItemRegister desc;
	UTF8ToUTF16(regID_utf8, &wbuff);
	UTF8ToUTF16(iconEntityName_utf8, &wbuff2);
	UTF8ToUTF16(functionName_utf8, &wbuff3);
	UTF8ToUTF16(checkFunctionName_utf8, &wbuff4);
	desc.stackable = stackable;
	desc.iconEntityName = wbuff2.data();
	desc.fName = wbuff3.data();
	desc.checkFName = wbuff4.data();
	pItemSystem->RegisterItem(wbuff.data(), desc);
}

int ScriptCmd::ITP(const char* regID_utf8, int num)
{
	UTF8ToUTF16(regID_utf8, &wbuff);
	return ITP(wbuff.data(), num);
}

int ScriptCmd::ITP(const wchar_t* regID, int num)
{
	return pItemSystem->AddItem(regID, num);
}

int ScriptCmd::ITS(const char* regID_utf8, int num)
{
	UTF8ToUTF16(regID_utf8, &wbuff);
	return ITS(wbuff.data(), num);
}

int ScriptCmd::ITS(const wchar_t* regID, int num)
{
	int index = pItemSystem->FindItem(regID);
	if (index == -1)
		return 0;
	auto& itemList = *pItemSystem->GetItemList();
	auto& item = itemList[index];
	if (num == -1)
	{
		item.num = 0;
	}
	else
	{
		item.num -= num;
		if (item.num <= 0)
			item.num = 0;
	}
	return item.num;
}

int ScriptCmd::ITS()
{
	auto& itemList = *pItemSystem->GetItemList();
	for (auto & p : itemList)
		p.num = 0;
	return 0;
}

bool ScriptCmd::ITJ(const char* regID_utf8, int num)
{
	UTF8ToUTF16(regID_utf8, &wbuff);
	int index = pItemSystem->FindItem(wbuff.data());
	if (index == -1)
		return false;
	auto& itemList = *pItemSystem->GetItemList();
	auto& item = itemList[index];
	return item.num >= num;
}

int ScriptCmd::ITC(const char* regID_utf8)
{
	UTF8ToUTF16(regID_utf8, &wbuff);
	return ITC(wbuff.data());
}

int ScriptCmd::ITC(const wchar_t* regID)
{
	int index = pItemSystem->FindItem(regID);
	if (index == -1)
		return 0;
	auto& itemList = *pItemSystem->GetItemList();
	auto& item = itemList[index];
	return item.num;
}

void ScriptCmd::RGM(const char* regID_utf8, const char* iconEntityName_utf8,
	const char* missionName_utf8, const char* functionName_utf8, const char* checkFunctionName_utf8)
{
	MissionRegister desc;
	UTF8ToUTF16(regID_utf8, &wbuff);
	UTF8ToUTF16(iconEntityName_utf8, &wbuff2);
	UTF8ToUTF16(missionName_utf8, &wbuff3);
	UTF8ToUTF16(functionName_utf8, &wbuff4);
	UTF8ToUTF16(checkFunctionName_utf8, &wbuff5);
	desc.iconEntityName = wbuff2.data();
	desc.name = wbuff3.data();
	desc.fName = wbuff4.data();
	desc.checkFName = wbuff5.data();
	pItemSystem->RegisterMission(wbuff.data(), desc);
}

void ScriptCmd::MSA(const char* regID_utf8)
{
	UTF8ToUTF16(regID_utf8, &wbuff);
	pItemSystem->AddMission(wbuff.data());
}

void ScriptCmd::MSD(const char* regID_utf8)
{
	UTF8ToUTF16(regID_utf8, &wbuff);
	pItemSystem->DeleteMission(wbuff.data());
}

void ScriptCmd::MSD()
{
	pItemSystem->DeleteAllMission();
}

void ScriptCmd::MSR(const char* regID_src_utf8, const char* regID_dst_utf8)
{
	UTF8ToUTF16(regID_src_utf8, &wbuff);
	UTF8ToUTF16(regID_dst_utf8, &wbuff2);
	pItemSystem->ReplaceMission(wbuff.data(), wbuff2.data());
}

bool ScriptCmd::MSJ(const char* regID_utf8)
{
	UTF8ToUTF16(regID_utf8, &wbuff);
	auto iter = pItemSystem->FindMission(wbuff.data());
	return iter != pItemSystem->GetMissionList()->end();
}

void ScriptCmd::SUB(bool bSub)
{
	usingMainGameCmd = bSub;
}

void ScriptCmd::LOC(int checkItemIndex, bool bLock)
{
	pItemSystem->LockItem(checkItemIndex, bLock);
}

bool ScriptCmd::LOC(int checkItemIndex)
{
	return pItemSystem->ItemLocked(checkItemIndex);
}

void ScriptCmd::GIT(const char* regID_utf8, int num)
{
	UTF8ToUTF16(regID_utf8, &wbuff);
	pItemSystem->SetShowMiniItem(true, wbuff.data(), num);
}

void ScriptCmd::GIT()
{
	pItemSystem->SetShowMiniItem(false, L"", 0);
}

bool ScriptCmd::IsMainGame()
{
	return usingMainGameCmd;
}

int ScriptCmd::GetCheckItemIndex()
{
	return pGameScrpt->GetCheckItemIndex();
}

void ScriptCmd::IMM()
{
	for (auto& wplayer : *globalEntity)
		wplayer->ImmUpdate();
}

void ScriptCmd::SKP(const char* flagName_utf8)
{
	UTF8ToUTF16(flagName_utf8, &wbuff);
	if (pSkipSet->find(wbuff.data()) == pSkipSet->end())
		pSkipSet->insert(wbuff.data());
}

void ScriptCmd::SKS(const char* flagName_utf8)
{
	UTF8ToUTF16(flagName_utf8, &wbuff);
	pSkipSet->erase(wbuff.data());
}

bool ScriptCmd::SKJ(const char* flagName_utf8)
{
	UTF8ToUTF16(flagName_utf8, &wbuff);
	return pSkipSet->find(wbuff.data()) != pSkipSet->end();
}

void ScriptCmd::POS(bool save)
{
	if (save)
		game->SaveAllPlayerPosition();
	else
		game->LoadAllPlayerPosition();
}

void ScriptCmd::CMP(const char* layerCopyFrom_utf8, const char* layerCopyTo_utf8)
{
	UTF8ToUTF16(layerCopyFrom_utf8, &wbuff);
	UTF8ToUTF16(layerCopyTo_utf8, &wbuff2);
	pGameMap->CMP(wbuff.data(), wbuff2.data());
}

void ScriptCmd::CMP(const char* layerCopyFrom_utf8, const char* layerCopyTo_utf8, const char* smokeNpcName_utf8)
{
	UTF8ToUTF16(layerCopyFrom_utf8, &wbuff);
	UTF8ToUTF16(layerCopyTo_utf8, &wbuff2);
	UTF8ToUTF16(smokeNpcName_utf8, &wbuff3);
	std::vector<LONG> posArr;
	pGameMap->CMP(wbuff.data(), wbuff2.data(), &posArr);
	//NPC
	for (auto& p : posArr)
	{
		int X = LOWORD(p);
		int Y = HIWORD(p);
		auto we = game->gameFunc.GameCreateEntity(wbuff3.data());
		if (we)
		{
			we->last_x = we->x = X * 16 + 8.0f;
			we->last_y = we->y = Y * 16 + 8.0f;
			auto wplayer = (*mychar_ptr_Player1).lock();
			if (wplayer)
			{
				game->gameFunc.SetEntity(wplayer, we);
			}
		}
	}
}

void ScriptCmd::QUA(int times, int mode)
{
	pCamera->SetQuake(times, mode);
}

void ScriptCmd::SWC(int playerIndex, const char* npcName_utf8, const char* globalEntityID_utf8, bool extendHpMax)
{
	std::weak_ptr<Entity> player;
	if(playerIndex == 0)
		player = *mychar_ptr_Player1;
	else
		player = *mychar_ptr_Player2;
	auto wplayer = player.lock();
	if (wplayer)
	{
		//ɾԭ
		wplayer->hide = true;
		wplayer->Destroy();
		UTF8ToUTF16(npcName_utf8, &wbuff);
		auto we = GameCreateEntity(wbuff.data());
		we->x = wplayer->x;
		we->y = wplayer->y;
		we->last_x = wplayer->last_x;
		we->last_y = wplayer->last_y;
		we->lr = wplayer->lr;
		we->el.name = wbuff.data();
		we->gameFunc = &game->gameFunc;
		we->SetState(0, we->lr);
		if (!we->initCheck)
			we->Init(we);
		globalEntity_addList->push_back(we);
		UTF8ToUTF16(globalEntityID_utf8, &wbuff2);
		(*globalEntityTable)[wbuff2.data()] = we;
		we->globalEntityID = wbuff2.data();
		if (extendHpMax)
		{
			we->hp_max = max(wplayer->hp_max, we->hp_max);
			we->hp = we->hp_max;
		}
		SPL(playerIndex, globalEntityID_utf8);
	}
}

void ScriptCmd::SWP()
{
	game->SwapPlayer();
}

const char* ScriptCmd::MCN(int playerIndex)
{
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[playerIndex].lock();
	if(wplayer)
	{
		UTF16ToUTF8(wplayer->el.name.c_str(), &utf8);
		return utf8.data();
	}
	else
	{
		return "";
	}
}

int ScriptCmd::MCI(const char* mycharName_utf8)
{
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	UTF8ToUTF16(mycharName_utf8, &wbuff);
	for (int i = 0; i < _countof(players); i++)
	{
		auto wplayer = players[i].lock();
		if (wplayer)
		{
			if (wplayer->el.name == wbuff.data())
				return i;
		}
	}
	return 0;
}

int ScriptCmd::GOP()
{
	return gameOption_playerNum;
}

void ScriptCmd::FLA(int times)
{
	game->gameFlash.SetScreenFlash(times);
}

int ScriptCmd::KIL(const char* npcName_utf8, int damage)
{
	UTF8ToUTF16(npcName_utf8, &wbuff);
	return pEntityRes->KillNpc(wbuff.data(), damage);
}

void ScriptCmd::STA(const char* smokeNpcName_utf8, int num, const char* soundName_utf8)
{
	UTF8ToUTF16(smokeNpcName_utf8, &wbuff);
	UTF8ToUTF16(soundName_utf8, &wbuff2);
	pEntityRes->SetStarBlockBreakEffect(wbuff.data(), num, wbuff2.data());
}

void ScriptCmd::ZAM()
{
	for (auto& wplayer : *globalEntity)
		wplayer->mp = 0;
}

void ScriptCmd::ZAM(int playerIndex)
{
	std::weak_ptr<Entity> players[2];
	players[0] = pEntityRes->GetMyChar_Player1();
	players[1] = pEntityRes->GetMyChar_Player2();
	auto wplayer = players[playerIndex].lock();
	if (wplayer)
		wplayer->mp = 0;
}

void ScriptCmd::RST(std::vector<std::wstring>& nameArr)
{
	pEntityRes->ResetEnemy(nameArr);
}

void ScriptCmd::CRE(const char* creditName_utf8)
{
	game->credit.reset();
	game->credit = std::make_unique<MyGame>();
	game->credit->Init(game->pRenderer, game->pInput, game->pJoystickInput, &game->creditView, &game->gameFunc);
	UTF8ToUTF16(creditName_utf8, &wbuff);
	game->credit->LoadSetting(wbuff.data());
}

void ScriptCmd::CRE()
{
	game->credit.reset();
}

const char* ScriptCmd::KEN(int playerIndex, int keyIndex)
{
	InputSetting_Keyboard* is = playerIndex == 0 ? game->gameFunc.GetInputSetting_Player1Keyboard() : game->gameFunc.GetInputSetting_Player2Keyboard();
	SDL_Scancode* bindArr[] =
	{
		&is->op_up,
		&is->op_down,
		&is->op_left,
		&is->op_right,
		&is->op_ok,
		&is->op_cancel,
		&is->op_jump,
		&is->op_atk,
		&is->op_menu,
		&is->op_inventory,
		&is->op_map,
		&is->op_pagePrev,
		&is->op_pageNext,
		&is->op_switchMc,
		&is->op_skill_1,
		&is->op_skill_2,
		&is->op_skill_3,
		&is->op_skill_4,
		&is->op_skill_5,
		&is->op_skill_6,
	};
	if (keyIndex >= _countof(bindArr))
		keyIndex = _countof(bindArr) - 1;
	game->gameFunc.GetScanCodeName(&wbuff, *bindArr[keyIndex]);
	UTF16ToUTF8(wbuff.data(), &utf8);
	return utf8.data();
}

int ScriptCmd::DIF()
{
	return gameOption_difficulty;
}
