#include "GameInput.h"

InputSetting_Joystick::InputSetting_Joystick()
{
	SDL_GameControllerButtonBind key;
	//--------------------*ҡ*---------------------
	//
	key.bindType = SDL_CONTROLLER_BINDTYPE_AXIS;
	key.value.axis = SDL_CONTROLLER_AXIS_LEFTY;
	op_up = key;
	op_down = key;
	//
	key.value.axis = SDL_CONTROLLER_AXIS_LEFTX;
	op_left = key;
	op_right = key;
	//5
	key.value.axis = SDL_CONTROLLER_AXIS_TRIGGERLEFT;
	op_skill_5 = key;
	//6
	key.value.axis = SDL_CONTROLLER_AXIS_TRIGGERRIGHT;
	op_skill_6 = key;
	//----------------------*ʮּ*--------------------
	//һҳ
	key.bindType = SDL_CONTROLLER_BINDTYPE_BUTTON;
	key.value.button = SDL_CONTROLLER_BUTTON_DPAD_LEFT;
	op_pagePrev = key;
	//һҳ
	key.value.button = SDL_CONTROLLER_BUTTON_DPAD_RIGHT;
	op_pageNext = key;
	//л
	key.value.button = SDL_CONTROLLER_BUTTON_DPAD_UP;
	op_switchMc = key;
	//ͼ
	key.value.button = SDL_CONTROLLER_BUTTON_DPAD_DOWN;
	op_map = key;
	//----------------------*ť*----------------------
	//ȷ
	key.bindType = SDL_CONTROLLER_BINDTYPE_BUTTON;
	key.value.button = SDL_CONTROLLER_BUTTON_X;
	op_ok = key;
	//ȡ
	key.value.button = SDL_CONTROLLER_BUTTON_A;
	op_cancel = key;
	//Ծ
	key.value.button = SDL_CONTROLLER_BUTTON_A;
	op_jump = key;
	//
	key.value.button = SDL_CONTROLLER_BUTTON_X;
	op_atk = key;
	//˵
	key.value.button = SDL_CONTROLLER_BUTTON_BACK;
	op_menu = key;
	//
	key.value.button = SDL_CONTROLLER_BUTTON_START;
	op_inventory = key;
	//1
	key.value.button = SDL_CONTROLLER_BUTTON_B;
	op_skill_1 = key;
	//2
	key.value.button = SDL_CONTROLLER_BUTTON_Y;
	op_skill_2 = key;
	//3
	key.value.button = SDL_CONTROLLER_BUTTON_LEFTSHOULDER;
	op_skill_3 = key;
	//4
	key.value.button = SDL_CONTROLLER_BUTTON_RIGHTSHOULDER;
	op_skill_4 = key;
}

GameInput::GameInput(DWORD key)
{
	this->key = key;
}

bool GameInput::GetUp()
{
	return key & keybit_up;
}

bool GameInput::GetDown()
{
	return key & keybit_down;
}

bool GameInput::GetLeft()
{
	return key & keybit_left;
}

bool GameInput::GetRight()
{
	return key & keybit_right;
}

bool GameInput::GetOk()
{
	return key & keybit_ok;
}

bool GameInput::GetCancel()
{
	return key & keybit_cancel;
}

bool GameInput::GetJump()
{
	return key & keybit_jump;
}

bool GameInput::GetAtk()
{
	return key & keybit_atk;
}

bool GameInput::GetMenu()
{
	return key & keybit_menu;
}

bool GameInput::GetInventory()
{
	return key & keybit_inventory;
}

bool GameInput::GetMap()
{
	return key & keybit_map;
}

bool GameInput::GetPagePrev()
{
	return key & keybit_pagePrev;
}

bool GameInput::GetPageNext()
{
	return  key & keybit_pageNext;
}

bool GameInput::GetSwitchMc()
{
	return key & keybit_switchMc;
}

bool GameInput::GetSkill_1()
{
	return key & keybit_skill_1;
}

bool GameInput::GetSkill_2()
{
	return key & keybit_skill_2;
}

bool GameInput::GetSkill_3()
{
	return key & keybit_skill_3;
}

bool GameInput::GetSkill_4()
{
	return key & keybit_skill_4;
}

bool GameInput::GetSkill_5()
{
	return key & keybit_skill_5;
}

bool GameInput::GetSkill_6()
{
	return key & keybit_skill_6;
}

void GameInput::SetUp(bool pressed)
{
	if (pressed)
		key |= keybit_up;
	else
		key &= ~keybit_up;
}

void GameInput::SetDown(bool pressed)
{
	if (pressed)
		key |= keybit_down;
	else
		key &= ~keybit_down;
}

void GameInput::SetLeft(bool pressed)
{
	if (pressed)
		key |= keybit_left;
	else
		key &= ~keybit_left;
}

void GameInput::SetRight(bool pressed)
{
	if (pressed)
		key |= keybit_right;
	else
		key &= ~keybit_right;
}

void GameInput::SetOk(bool pressed)
{
	if (pressed)
		key |= keybit_ok;
	else
		key &= ~keybit_ok;
}

void GameInput::SetCancel(bool pressed)
{
	if (pressed)
		key |= keybit_cancel;
	else
		key &= ~keybit_cancel;
}

void GameInput::SetJump(bool pressed)
{
	if (pressed)
		key |= keybit_jump;
	else
		key &= ~keybit_jump;
}

void GameInput::SetAtk(bool pressed)
{
	if (pressed)
		key |= keybit_atk;
	else
		key &= ~keybit_atk;
}

void GameInput::SetMenu(bool pressed)
{
	if (pressed)
		key |= keybit_menu;
	else
		key &= ~keybit_menu;
}

void GameInput::SetInventory(bool pressed)
{
	if (pressed)
		key |= keybit_inventory;
	else
		key &= ~keybit_inventory;
}

void GameInput::SetMap(bool pressed)
{
	if (pressed)
		key |= keybit_map;
	else
		key &= ~keybit_map;
}

void GameInput::SetPagePrev(bool pressed)
{
	if (pressed)
		key |= keybit_pagePrev;
	else
		key &= ~keybit_pagePrev;
}

void GameInput::SetPageNext(bool pressed)
{
	if (pressed)
		key |= keybit_pageNext;
	else
		key &= ~keybit_pageNext;
}

void GameInput::SetSwitchMc(bool pressed)
{
	if (pressed)
		key |= keybit_switchMc;
	else
		key &= ~keybit_switchMc;
}

void GameInput::SetSkill_1(bool pressed)
{
	if (pressed)
		key |= keybit_skill_1;
	else
		key &= ~keybit_skill_1;
}

void GameInput::SetSkill_2(bool pressed)
{
	if (pressed)
		key |= keybit_skill_2;
	else
		key &= ~keybit_skill_2;
}

void GameInput::SetSkill_3(bool pressed)
{
	if (pressed)
		key |= keybit_skill_3;
	else
		key &= ~keybit_skill_3;
}

void GameInput::SetSkill_4(bool pressed)
{
	if (pressed)
		key |= keybit_skill_4;
	else
		key &= ~keybit_skill_4;
}

void GameInput::SetSkill_5(bool pressed)
{
	if (pressed)
		key |= keybit_skill_5;
	else
		key &= ~keybit_skill_5;
}

void GameInput::SetSkill_6(bool pressed)
{
	if (pressed)
		key |= keybit_skill_6;
	else
		key &= ~keybit_skill_6;
}
