#include "DmgNum.h"
#include "MyView.h"
#include "main.h"
#include "Entity.h"
void DmgNum::Init(MyDX11Renderer* pRenderer, MyView* pView)
{
	this->pRenderer = pRenderer;
	this->pView = pView;
}

void DmgNum::Reset()
{
	dmgList.clear();
	expList.clear();
	recList.clear();
	qmList.clear();
}

void DmgNum::Step()
{
	std::list<NumEntity>* numArr[] = { &dmgList ,&expList,&recList };
	for (auto& targetList : numArr)
	{
		for (auto& num : *targetList)
		{
			// Ŀλ
			num.last_x = num.x;
			num.last_y = num.y;
			auto we = num.entity.lock();
			if (we)
			{
				num.x = we->x + (we->cbRect.right - we->cbRect.left) / 2;
				num.y = we->y - we->cbRect.top - 16;
			}
			if (num.exist_time > 0)
			{
				num.exist_time--;
			}
			else
			{
				if (num.timecounter > 0)
					num.timecounter--;
			}
		}
		targetList->remove_if([](const auto& e)
		{
			return e.timecounter <= 0;
		});
	}
	//ʺ
	for (auto& qm : qmList)
	{
		if (qm.timecounter > 0)
		{
			qm.timecounter--;
			qm.last_x = qm.x;
			qm.last_y = qm.y;
			if (qm.timecounter < qm.disappear)
				qm.y -= 0.2f;
		}
	}
	qmList.remove_if([](const auto& e)
	{
		return e.timecounter <= 0;
	});
}

void DmgNum::Draw(float delteTime)
{
	//˺ֵ
	char numbuff[16];
	auto& tas = *GetSysTexture(DMGNUM_TEXTURE);
	pRenderer->SetTPenDraw(tas.pSRV);

	MyRect src, dst;
	float srcX, srcY, srcW, srcH;
	float dstX, dstY, dstW, dstH;
	int time = 0;
	DWORD c;
	std::list<NumEntity>* numArr[] = { &dmgList ,&expList,&recList };
	for (auto& targetList : numArr)
	{
		for (auto& num : *targetList)
		{
			sprintf_s(numbuff, "%d", num.num);
			int len = (int)strlen(numbuff);
			time = 0;

			srcY = 32 + num.style * 8.0f;
			srcW = 8;
			srcH = 8;
			dstW = srcW * pView->scale;
			dstH = srcH * pView->scale;
			float draw_x = lerp(num.last_x, num.x, delteTime);
			float draw_y = lerp(num.last_y, num.y, delteTime);
			for (int i = -1; i < len; i++)
			{
				if (i == -1)
					srcX = 80;
				else
					srcX = (numbuff[i] - '0') * 8.0f;
				dstX = (time + draw_x - (len + 1) * 8.0f / 2) * pView->scale - floorf(pView->offX * pView->scale);
				dstY = draw_y * pView->scale - floorf(pView->offY * pView->scale);
				c = RGBA(0xff, 0xff, 0xff, num.timecounter * 0xff / num.timecounter_max);
				src.Set1(srcX, srcY, srcW, srcH);
				dst.Set1(dstX, dstY, dstW, dstH);
				pRenderer->AddRenderCopy(&src, &dst, c);
				time += 8;
			}
		}
	}
	//ʺ
	src.Set1(30, 0, 5, 10);
	for (auto& e : qmList)
	{
		float draw_x = lerp(e.last_x, e.x, delteTime);
		float draw_y = lerp(e.last_y, e.y, delteTime);
		UINT8 alpha = (UINT8)min(e.timecounter * 0xff / e.disappear, 0xff);
		c = RGBA(0xff, 0xff, 0xff, alpha);
		dst.Set1((draw_x - 2) * pView->scale - floorf(pView->offX * pView->scale),
			draw_y * pView->scale - floorf(pView->offY * pView->scale),
			5 * pView->scale,
			10 * pView->scale);
		pRenderer->AddRenderCopy(&src, &dst, c);
	}
	pRenderer->DrawRenderCopy();
}

void DmgNum::SetNum(int val, float x, float y, int style, std::weak_ptr<Entity> e)
{
	if (val <= 0)
		return;
	//ʵ壬Ƿиʵ˺
	std::list<NumEntity>* numArr[] = { &dmgList,&dmgList ,&expList,&recList };
	auto& targetList = numArr[style];
	auto we = e.lock();
	if (we)
	{
		for (auto& p : *targetList)
		{
			//ǷѾͬʵֵ
			if (p.entity.lock() == we)
			{
				// ۼֵ
				p.num += val;
				p.exist_time = p.exist_time_max;
				p.timecounter = p.timecounter_max;
				return;
			}
		}
	}
	NumEntity num;
	num.num = val;
	num.style = style;
	num.last_x = num.x = x;
	num.last_y = num.y = y;
	num.entity = e;
	targetList->push_back(num);
	if (we)
	{
		// Ŀλ
		num.x = we->x + (we->cbRect.right - we->cbRect.left) / 2;
		num.y = we->y - we->cbRect.top - 16;
	}
}

void DmgNum::SetQuestionMark(float x, float y)
{
	QuestionMarkEntity qm;
	qm.last_x = qm.x = x;
	qm.last_y = qm.y = y;
	qmList.push_back(qm);
}
