#include "CNewAni.h"
#include "resource.h"

IMPLEMENT_DYNAMIC(CNewAni, CDialog)

BEGIN_MESSAGE_MAP(CNewAni, CDialog)
	ON_BN_CLICKED(IDOK, &CNewAni::OnBnClickedOk)
END_MESSAGE_MAP()

CNewAni::CNewAni(CWnd* pParent)
	: CDialog(IDD_CANIEDITOR_NEWANI, pParent)
{
}

CNewAni::~CNewAni()
{
}

void CNewAni::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_ANINAME, edit_aniName);
	DDX_Control(pDX, IDC_EDIT_ANILEN, edit_aniLen);
	DDX_Control(pDX, IDC_EDIT_LAYERNUM, edit_layerNum);
	DDX_Control(pDX, IDC_EDIT_PLAYSPEED, edlit_playSpeed);
	DDX_Control(pDX, IDC_CHECK_LOOPANI, button_loopAni);
	DDX_Control(pDX, IDC_EDIT_TEXTURE_UP, edit_texture_up);
	DDX_Control(pDX, IDC_EDIT_TEXTURE_DOWN, edit_texture_down);
	DDX_Control(pDX, IDC_EDIT_TEXTURE_LEFT, edit_texture_left);
	DDX_Control(pDX, IDC_EDIT_TEXTURE_RIGHT, edit_texture_right);
}

BOOL CNewAni::OnInitDialog()
{
	CDialog::OnInitDialog();
	if (outAniName.GetLength() > 0)
	{
		SetWindowText(L"༭");
	}
	SetDlgItemTextW(IDC_EDIT_ANINAME, outAniName.GetString());
	SetDlgItemInt(IDC_EDIT_ANILEN, outAniLen);
	SetDlgItemInt(IDC_EDIT_LAYERNUM, outLayerNum);
	SetDlgItemInt(IDC_EDIT_PLAYSPEED, outPlaySpeed);
	button_loopAni.SetCheck(outLoopAni);
	CString str;
	str.Format(L"%d", outTextureUp);
	edit_texture_up.SetWindowTextW(str.GetString());
	str.Format(L"%d", outTextureDown);
	edit_texture_down.SetWindowTextW(str.GetString());
	str.Format(L"%d", outTextureLeft);
	edit_texture_left.SetWindowTextW(str.GetString());
	str.Format(L"%d", outTextureRight);
	edit_texture_right.SetWindowTextW(str.GetString());
	return 0;
}


void CNewAni::OnBnClickedOk()
{
	
	CString aniName;
	edit_aniName.GetWindowTextW(aniName);
	if (aniName.GetLength() == 0)
	{
		MessageBoxW(L"дid", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	if (aniName != outAniName && pAs->find(aniName.GetString()) != pAs->end())
	{
		CString err;
		err.Format(L"ͬid%s", aniName.GetString());
		MessageBoxW(err.GetString(), L"дϢͻ", MB_ICONINFORMATION);
		return;
	}
	CString texture_up;
	edit_texture_up.GetWindowTextW(texture_up);
	if (texture_up.GetLength() == 0)
	{
		MessageBoxW(L"дϱ߽硿", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	outTextureUp = GetDlgItemInt(IDC_EDIT_TEXTURE_UP);

	CString texture_down;
	edit_texture_down.GetWindowTextW(texture_down);
	if (texture_down.GetLength() == 0)
	{
		MessageBoxW(L"д±߽硿", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	outTextureDown = GetDlgItemInt(IDC_EDIT_TEXTURE_DOWN);

	CString texture_left;
	edit_texture_left.GetWindowTextW(texture_left);
	if (texture_left.GetLength() == 0)
	{
		MessageBoxW(L"д߽硿", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	outTextureLeft = GetDlgItemInt(IDC_EDIT_TEXTURE_LEFT);

	CString texture_right;
	edit_texture_right.GetWindowTextW(texture_right);
	if (texture_right.GetLength() == 0)
	{
		MessageBoxW(L"дұ߽硿", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	outTextureRight = GetDlgItemInt(IDC_EDIT_TEXTURE_RIGHT);

	CString aniLen;
	edit_aniLen.GetWindowTextW(aniLen);
	if (aniLen.GetLength() == 0)
		SetDlgItemInt(IDC_EDIT_ANILEN, 0);
	CString layerNum;
	edit_layerNum.GetWindowTextW(layerNum);
	if (layerNum.GetLength() == 0)
		SetDlgItemInt(IDC_EDIT_LAYERNUM, 0);
	CString playerSpeed;
	edlit_playSpeed.GetWindowTextW(playerSpeed);
	if (playerSpeed.GetLength() == 0)
		SetDlgItemInt(IDC_EDIT_PLAYSPEED, 0);
	outAniName = aniName;
	outAniLen = GetDlgItemInt(IDC_EDIT_ANILEN);
	outLayerNum = GetDlgItemInt(IDC_EDIT_LAYERNUM);
	outPlaySpeed = GetDlgItemInt(IDC_EDIT_PLAYSPEED);
	outLoopAni = button_loopAni.GetCheck();
	CDialog::OnOK();
}
