#pragma once
#include "global.h"
#include "MyStructDef.h"
class CAniEditorTimeLine : public CDialog
{
	DECLARE_DYNAMIC(CAniEditorTimeLine)
	DECLARE_MESSAGE_MAP()
public:
	CAniEditorTimeLine(CWnd* pParent = nullptr);   // ׼캯
	virtual ~CAniEditorTimeLine();
	// Ի
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_CANIEDITOR_TIMELINE };
#endif
	void* pParentEditor = nullptr;
	bool showBk = true;
	bool isDark = true;
	void Draw();
	void Load(CString filename);//ͼpngļ
	MyView* GetMyView();
	void SetLayerNumAndAniLen(int aniLen, int layerNum);
	MyAniFrame GetCurFrame();
	int GetTimeIndex();
	void SetTimeIndex(int index);
protected:
	void DoDataExchange(CDataExchange* pDX) override;
	BOOL OnInitDialog() override;
public:
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnPaint();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
private:
	//Ⱦ
	MyDX11Renderer pRenderer;
	MyView view;
	MyTextureAndSRV tas;
	TTF_Font* pFont_sourcesun70 = nullptr;//
	std::unordered_map<wchar_t, MyFontData> pFontMap70;
	TTF_Font* pFont_sourcesun14 = nullptr;//
	std::unordered_map<wchar_t, MyFontData> pFontMap14;
	CPoint rclick_last_pt;//ͼ༭
	int timeIndex = 0;
	bool selecting = false;
	DWORD timeIndexColor_DarkGrid = RGBA(0xff, 0x62, 0x4c, 0xff);
	DWORD timeIndexColor_DarkFill = RGBA(0x79, 0x2d, 0x22, 0xff);
	DWORD timeIndexColor_LightGrid = RGBA(0xff, 0x0, 0x0, 0xff);
	DWORD timeIndexColor_LightFill = RGBA(0xfd, 0xc8, 0xc0, 0xff);
	void DrawTimeRuler();//ʱ
	void DrawNumber(float x, float y, int num, MyRect* rc);
	void DrawTimeIndex();
	void DrawAni();
};

