#include "CAniEditorHideTable.h"
#include <sstream>
#include "resource.h"

IMPLEMENT_DYNAMIC(CAniEditorHideTable, CDialog)

BEGIN_MESSAGE_MAP(CAniEditorHideTable, CDialog)
	ON_BN_CLICKED(IDOK, &CAniEditorHideTable::OnBnClickedOk)
END_MESSAGE_MAP()

CAniEditorHideTable::CAniEditorHideTable(CWnd* pParent)
	: CDialog(IDD_CANIEDITOR_HIDETABLE, pParent)
{
}

CAniEditorHideTable::~CAniEditorHideTable()
{
}

void CAniEditorHideTable::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_NUMTEXT, edit_numText);
}

BOOL CAniEditorHideTable::OnInitDialog()
{
	CDialog::OnInitDialog();
	edit_numText.SetWindowTextW(outStr.GetString());
	return 0;
}

bool CAniEditorHideTable::ParseInts(const wchar_t* str, std::vector<int>& outArr)
{
	std::wstringstream ss(str);
	std::wstring item;
	wchar_t delimiter = L',';

	outArr.clear();
	while (std::getline(ss, item, delimiter))
	{
		try 
		{
			outArr.push_back(std::stoi(item));
		}
		catch (const std::exception) 
		{
			return false;
		}
	}
	return true;
}

void CAniEditorHideTable::OnBnClickedOk()
{
	CString numText;
	edit_numText.GetWindowTextW(numText);
	std::vector<int> temp;
	//ַ
	if (!ParseInts(numText.GetString(), temp))
	{
		MessageBoxW(L"ַʧܣ\nöŸ", L"ıʧ");
		return;
	}
	outStr = numText;
	CDialog::OnOK();
}
