#include "PeWhiteShadow.h"

PeWhiteShadow::PeWhiteShadow()
{
	type = 3;
	shader.usingShader = true;
	shader.vs = shader.ps = L"whiteshadow";
	action_timecounter_max = 60;
	action_timecounter = action_timecounter_max;
	drawBeforeOtherEntity = true;
}

void PeWhiteShadow::Step()
{
	BYTE alpha = (BYTE)floorf((float)action_timecounter * 0xff / action_timecounter_max);
	color = RGBA(0xff, 0xff, 0xff, alpha);
	if (action_timecounter > 0)
	{
		action_timecounter--;
		if (action_timecounter == 0)
			Destroy();
	}
}

void SetPeWhiteShadow(std::shared_ptr<Entity> parent)
{
	auto e = std::make_shared<PeWhiteShadow>();
	e->x = parent->x;
	e->y = parent->y;
	e->ani = parent->ani;
	parent->gameFunc->SetEntity(parent, e);
}
