#pragma once
#include "Entity.h"
class MenuTextJoystick :
    public Entity
{
public:
    virtual InputSetting_Joystick* GetInputSetting() = 0;
    virtual SDL_GameControllerButtonBind* GetBind(InputSetting_Joystick* setting) = 0;
    virtual std::weak_ptr<Entity> GetPlayer(void* entityRes) = 0;
    void Init(std::weak_ptr<Entity> self) override;
    void Step() override;
    void SetState(int stateID, int lr) override;
protected:
    std::vector<wchar_t> name;
    int stateID = 0;
    std::weak_ptr<Entity> icon;
};

