#include "MenuResetKey_Player2Joystick.h"

#include "MenuTextUp_Player2Joystick.h"
#include "MenuTextDown_Player2Joystick.h"
#include "MenuTextLeft_Player2Joystick.h"
#include "MenuTextRight_Player2Joystick.h"
#include "MenuTextOk_Player2Joystick.h"
#include "MenuTextCancel_Player2Joystick.h"
#include "MenuTextJump_Player2Joystick.h"
#include "MenuTextAtk_Player2Joystick.h"
#include "MenuTextMenu_Player2Joystick.h"
#include "MenuTextInventory_Player2Joystick.h"
#include "MenuTextMap_Player2Joystick.h"
#include "MenuTextPagePrev_Player2Joystick.h"
#include "MenuTextPageNext_Player2Joystick.h"
#include "MenuTextSk1_Player2Joystick.h"
#include "MenuTextSk2_Player2Joystick.h"
#include "MenuTextSk3_Player2Joystick.h"
#include "MenuTextSk4_Player2Joystick.h"
#include "MenuTextSk5_Player2Joystick.h"
#include "MenuTextSk6_Player2Joystick.h"
#include "MenuTextSwitchMc_Player2Joystick.h"
MenuResetKey_Player2Joystick::MenuResetKey_Player2Joystick()
{
	ani.png = L"menu_CS_title";
	ani.sprite_index = L"msg_reset";
}

void MenuResetKey_Player2Joystick::Step()
{
	if (gameFunc->ResetKeySetting_Player2Joystick)
	{
		if (gameFunc->GetKey(SDL_SCANCODE_ESCAPE))
		{
			if (counter == 1)
			{
				gameFunc->PlaySound(L"MenuCancel");
				gameFunc->ResetKeySetting_Player2Joystick();
				gameFunc->SaveConfig();
				//޸bug
				std::weak_ptr<Entity> eArr[] = {
					GetEntityByType(MENUTEXTUP_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTMAP_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTDOWN_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTJUMP_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTLEFT_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTATK_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTRIGHT_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTSK1_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTOK_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTSK2_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTCANCEL_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTSK3_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTMENU_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTSK4_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTINVENTORY_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTSK5_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTPAGEPREV_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTSK6_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTPAGENEXT_PLAYER2JOYSTICK_CREATENAME),
					GetEntityByType(MENUTEXTSWITCHMC_PLAYER2JOYSTICK_CREATENAME),
				};
				for (int i = 0; i < _countof(eArr); i++)
				{
					auto we = eArr[i].lock();
					if (we)
					{
						we->ani.png = we->ani.sprite_index = L"";
						we->el.flag.text = true;
						we->SetState(0, 0);
					}
				}
			}
			if (counter > 0)
				counter--;
		}
		else
			counter = counter_max;
		if (counter == 0)
		{
			ani.sprite_index = L"msg_resetDone";
		}
		else if (counter >= counter_max)
		{
			ani.sprite_index = L"msg_reset";
		}
		else
		{
			int num = counter / 40;
			if (num >= 0 && num <= 4)
			{
				wchar_t buff[MAX_PATH];
				swprintf_s(buff, L"msg_count%d", num);
				ani.sprite_index = buff;
			}
		}
	}
}

std::weak_ptr<Entity> MenuResetKey_Player2Joystick::GetEntityByType(const wchar_t* name)
{
	auto loadedEntity = gameFunc->GetLoadedEntity(gameFunc->entityRes);
	for (auto& p : *loadedEntity)
	{
		for (auto& e : p.second.Ls)
		{
			if (e->el.name == name)
				return e;
		}
	}
	return std::weak_ptr<Entity>();
}

std::shared_ptr<Entity> CreateMenuResetKey_Player2Joystick()
{
	return std::make_shared<MenuResetKey_Player2Joystick>();
}