#include "CS_WaterLevel.h"

CS_WaterLevel::CS_WaterLevel()
{
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableWaterSpace = true;
	cbRect.left = 8;
	cbRect.right = 8;
	cbRect.top = 8;
	cbRect.bottom = 8;
	ani.sprite_index = L"ls_waterlevel";
}

void CS_WaterLevel::Init(std::weak_ptr<Entity> self)
{
	srcX = x;
	srcY = y;
	Entity::Init(self);
}

void CS_WaterLevel::Step()
{
	cbRect.bottom = srcY - y + 8;
	switch (stateID)
	{
	case 0://ֹͣ
		vy = 0;
		break;
	case 1://
		vy = -0x200 / ts;
		break;
	case 2://½
		vy = 0x200 / ts;
		break;
	}
	//ִ˶
	Entity::Step();
}

void CS_WaterLevel::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"stop")
		stateID = 0;
	else if (stateName == L"up")
		stateID = 1;
	else if (stateName == L"down")
		stateID = 2;
}

std::shared_ptr<Entity> CreateCS_WaterLevel()
{
	return std::make_shared<CS_WaterLevel>();
}
