#include "CS_TeleporterLargeBase.h"

CS_TeleporterLargeBase::CS_TeleporterLargeBase()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_teleporter_large_base_off";
	drawBeforeOtherEntity = true;
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.enableMovePlatform = true;
	cbRect.top = 0;
	cbRect.bottom = 8;
	cbRect.left = cbRect.right = 16;
}

void CS_TeleporterLargeBase::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	switch (stateID)
	{
	case 0:
		ani.sprite_index = L"ls_teleporter_large_base_off";
		break;
	case 1:
		ani.sprite_index = L"ls_teleporter_large_base_on";
		break;
	}
}

void CS_TeleporterLargeBase::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"light_off")
		SetState(0, lr);
	else if(stateName == L"light_on")
		SetState(1, lr);
}

std::shared_ptr<Entity> CreateCS_TeleporterLargeBase()
{
	return std::make_shared<CS_TeleporterLargeBase>();
}
