#include "CS_SkyDragonAni.h"

CS_SkyDragonAni::CS_SkyDragonAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 10;
	cbRect.top = 12;
	cbRect.bottom = 8;
	drawBeforeOtherEntity = true;
}

void CS_SkyDragonAni::Step()
{
	switch (stateID)
	{
	case 1:
		if (x < hover_x)
			vx += 8 / ts;
		else
			vx -= 8 / ts;

		if (y < hover_y)
			vy += 8 / ts;
		else
			vy -= 8 / ts;
		break;
	case 2:
		{
			auto wtarget = animation_target.lock();
			if (wtarget)
			{
				float dx = wtarget->x - x;
				float dy = wtarget->y - y;
				if (dx * dx + dy * dy > 12 * 12)
				{
					float vec_x = wtarget->x - x;
					float vec_y = wtarget->y - y;
					auto vec = XMVector2Normalize(XMVectorSet(vec_x, vec_y, 0, 0));
					float dir_vx = XMVectorGetX(vec);
					float dir_vy = XMVectorGetY(vec);
					vx = dir_vx * animation_moveSpeed;
					vy = dir_vy * animation_moveSpeed;
					lr = x > wtarget->x ? 0 : 1;
				}
				else
				{
					vx = vy = 0;
				}
				ani.sprite_index = lr == 0 ? L"mc_skydragon_kazuma_l" : L"mc_skydragon_kazuma_r";
			}
		}
		break;
	case 3:
		vx = 0;
		vy = 0x100 / ts;
		ani.sprite_index = lr == 0 ? L"mc_skydragon_kazuma_l" : L"mc_skydragon_kazuma_r";
		break;
	case 4:
		{
			// 뾶
			XMVECTOR vec = XMVector2Normalize(XMVectorSet(x - hover_x, y - hover_y, 0, 0));
			float dirX = XMVectorGetX(vec);
			float dirY = XMVectorGetY(vec);
			// ߷ٶ
			float angularSpeed = 0x100 / ts;
			/*vy = -dirX;
			vx = dirY;*/

			//Ҷ
			float a = 0.6f;
			vy = -2 * dirX * (2 * dirX * dirX + 2 * dirY * dirY - 3 * a * dirY);
			vx = 4 * dirY * (dirX * dirX + dirY * dirY) - 3 * a * (dirX * dirX - dirY * dirY);

			//ٶ
			vy *= angularSpeed;
			vx *= angularSpeed;
		}
		break;
	}
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_SkyDragonAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	//ö
	switch (stateID)
	{
	case 0://վ
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_skydragon_stand_l" : L"mc_skydragon_stand_r";
		break;
	case 1://
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_skydragon_kazuma_l" : L"mc_skydragon_kazuma_r";
		hover_y = y - 16;
		hover_x = x - 6;
		vy = 0;
		break;
	case 2://ɵĿ
		break;
	case 3://
		break;
	case 4:// ¡
		vx = 0;
		ani.sprite_index = L"mc_skydragon_toroko";
		hover_y = y - 48;
		hover_x = x;
		vy = 0;
		break;
	}
}

void CS_SkyDragonAni::SetState(std::wstring stateName, int lr)
{
	if (bSetTarget)
	{
		bSetTarget = false;
		auto& allRes = *gameFunc->GetLoadedEntity(gameFunc->entityRes);
		EntityLayer* eLayer = nullptr;
		for (auto& res : allRes)
		{
			if (res.first->layerType == 0)
			{
				eLayer = &res.second;
				break;
			}
		}
		if (eLayer)
		{
			bool bFound = false;
			//ȫʵѰ
			auto& allPlayer = *gameFunc->GetGlobalEntityTable(gameFunc->game);
			for (auto& p : allPlayer)
			{
				auto wplayer = p.second.lock();
				if (wplayer && wplayer->el.name == stateName)
				{
					animation_target = wplayer;
					bFound = true;
					break;
				}
			}
			//ڵͼʵѰ
			if (!bFound)
			{
				for (auto& e : eLayer->Ls)
				{
					if (e->el.eventName == stateName)
					{
						animation_target = e;
						break;
					}
				}
			}
		}
	}
	else
	{
		if (stateName == L"normal")
			SetState(0, lr);
		else if (stateName == L"hover_kazuma")
			SetState(1, lr);
		else if (stateName == L"set_target")
			bSetTarget = true;
		else if (stateName == L"fly_target")
			SetState(2, lr);
		else if (stateName == L"landing")
			SetState(3, lr);
		else if (stateName == L"hover_toroko")
			SetState(4, lr);
		else if (stateName == L"fly_speed_up")
			animation_moveSpeed = 0x400 / ts;
	}
}

std::shared_ptr<Entity> CreateCS_SkyDragonAni()
{
	return std::make_shared<CS_SkyDragonAni>();
}
