#include "CS_SetNumNpc.h"

CS_SetNumNpc::CS_SetNumNpc()
{
	hp = 100;
}

void CS_SetNumNpc::Step()
{
	if (setNpcNum == 0 && npcArr.empty())
	{
		hp = 0;
		Destroy();
	}
	if (bStartSet)
	{
		if (setNpcInterval > 0)
			setNpcInterval--;
		if (setNpcNum > 0 && setNpcInterval == 0)
		{
			setNpcInterval = setNpcInterval_max;
			setNpcNum--;
			//ĿNpc
			auto we = gameFunc->GameCreateEntity(npc_type.c_str());
			we->x = x;
			we->y = y;
			we->lr = lr;
			gameFunc->SetEntity(shared_from_this(), we);
			npcArr.push_back(we);
		}
	}
	//NpcǷͷ
	npcArr.remove_if([](std::weak_ptr<Entity>& e) 
	{
		return e.expired();
	});
}

void CS_SetNumNpc::SetState(std::wstring stateName, int lr)
{
	if (bSetNpcType)
	{
		bSetNpcType = false;
		npc_type = stateName;
	}
	else
	{
		if (stateName == L"set_npc_type")
			bSetNpcType = true;
		else if (stateName == L"set_npc_num")
			setNpcNum = lr;
		else if (stateName == L"set_npc_interval")
		{
			setNpcInterval_max = lr;
			setNpcInterval = Random(0, setNpcInterval_max);
		}
		else if (stateName == L"start")
			bStartSet = true;
	}
}

std::shared_ptr<Entity> CreateCS_SetNumNpc()
{
	return std::make_shared<CS_SetNumNpc>();
}